% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getPowerSurvival}
\alias{getPowerSurvival}
\title{Get Power Survival}
\usage{
getPowerSurvival(
  design = NULL,
  ...,
  typeOfComputation = c("Schoenfeld", "Freedman", "HsiehFreedman"),
  thetaH0 = 1,
  directionUpper = NA,
  pi1 = NA_real_,
  pi2 = NA_real_,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  median1 = NA_real_,
  median2 = NA_real_,
  kappa = 1,
  hazardRatio = NA_real_,
  piecewiseSurvivalTime = NA_real_,
  allocationRatioPlanned = 1,
  eventTime = 12L,
  accrualTime = c(0L, 12L),
  accrualIntensity = 0.1,
  accrualIntensityType = c("auto", "absolute", "relative"),
  maxNumberOfSubjects = NA_real_,
  maxNumberOfEvents = NA_real_,
  dropoutRate1 = 0,
  dropoutRate2 = 0,
  dropoutTime = 12L
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower}, 
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{typeOfComputation}{Three options are available: \code{"Schoenfeld"}, \code{"Freedman"}, \code{"HsiehFreedman"}, 
the default is \code{"Schoenfeld"}. For details, see Hsieh (Statistics in Medicine, 1992). 
For non-inferiority testing (i.e., \code{thetaH0 != 1}), only Schoenfeld's formula can be used.}

\item{thetaH0}{The null hypothesis value, 
default is \code{0} for the normal and the binary case (testing means and rates, respectively), 
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr 
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
  \item \emph{means}: a value \code{!= 0} 
    (or a value \code{!= 1} for testing the mean ratio) can be specified.
  \item \emph{rates}: a value \code{!= 0} 
    (or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
  \item \emph{survival data}: a bound for testing H0: \code{hazard ratio = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for 
defining the null hypothesis H0: \code{pi = thetaH0}.}

\item{directionUpper}{Specifies the direction of the alternative, 
only applicable for one-sided testing; default is \code{TRUE}
which means that larger values of the test statistics yield smaller p-values.}

\item{pi1}{A numeric value or vector that represents the assumed event rate in the treatment group, 
default is \code{seq(0.2, 0.5, 0.1)} (power calculations and simulations) or 
\code{seq(0.4, 0.6, 0.1)} (sample size calculations).}

\item{pi2}{A numeric value that represents the assumed event rate in the control group, default is \code{0.2}.}

\item{lambda1}{The assumed hazard rate in the treatment group, there is no default.
\code{lambda1} can also be used to define piecewise exponentially distributed survival times (see details).}

\item{lambda2}{The assumed hazard rate in the reference group, there is no default.
\code{lambda2} can also be used to define piecewise exponentially distributed survival times (see details).}

\item{median1}{The assumed median survival time in the treatment group, there is no default.}

\item{median2}{The assumed median survival time in the reference group, there is no default.}

\item{kappa}{A numeric value > 0. A \code{kappa != 1} will be used for the specification 
of the shape of the Weibull distribution. 
Default is \code{1}, i.e., the exponential survival distribution is used instead of the Weibull distribution.
Note that the Weibull distribution cannot be used for the piecewise definition of 
the survival time distribution, i.e., only \code{piecewiselambda} (as a single value) and \code{kappa} 
can be specified.
This function is equivalent to \code{pweibull(t, shape = kappa, scale = 1 / lambda)} 
of the \code{stats} package, i.e., the scale parameter is \code{1 / 'hazard rate'}.\cr
For example, 
\code{getPiecewiseExponentialDistribution(time = 130, piecewiseLambda = 0.01, kappa = 4.2)} 
and \code{pweibull(q = 130, shape = 4.2, scale = 1 / 0.01)} provide the sample result.}

\item{hazardRatio}{The vector of hazard ratios under consideration. 
If the event or hazard rates in both treatment groups are defined, the hazard ratio needs 
not to be specified as it is calculated, there is no default.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for the piecewise 
definition of the exponential survival time cumulative distribution function \cr
(for details see \code{\link{getPiecewiseSurvivalTime}}).}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups 
design, default is \code{1}. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control.}

\item{eventTime}{The assumed time under which the event rates are calculated, default is \code{12}.}

\item{accrualTime}{The assumed accrual time intervals for the study, default is 
\code{c(0, 12)} (for details see \code{\link{getAccrualTime}}).}

\item{accrualIntensity}{A vector of accrual intensities, default is the relative 
intensity \code{0.1} (for details see \code{\link{getAccrualTime}}).}

\item{accrualIntensityType}{A character value specifying the accrual intensity input type.
Must be one of \code{"auto"}, \code{"absolute"}, or \code{"relative"}; default is \code{"auto"},
i.e., if all values are < 1 the type is \code{"relative"}, otherwise it is \code{"absolute"}.}

\item{maxNumberOfSubjects}{\code{maxNumberOfSubjects > 0} needs to be specified.
If accrual time and accrual intensity is specified, this will be calculated.}

\item{maxNumberOfEvents}{\code{maxNumberOfEvents > 0} is the maximum number of events, it determines 
the power of the test and needs to be specified.}

\item{dropoutRate1}{The assumed drop-out rate in the treatment group, default is \code{0}.}

\item{dropoutRate2}{The assumed drop-out rate in the control group, default is \code{0}.}

\item{dropoutTime}{The assumed time for drop-out rates in the control and the 
treatment group, default is \code{12}.}
}
\value{
Returns a \code{\link{TrialDesignPlan}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
  \item \code{\link[=names.FieldSet]{names}} to obtain the field names,
  \item \code{\link[=print.FieldSet]{print}} to print the object,
  \item \code{\link[=summary.TrialDesignSet]{summary}} to display a summary of the object,
  \item \code{\link[=plot.TrialDesignPlan]{plot}} to plot the object,
  \item \code{\link[=as.data.frame.TrialDesignPlan]{as.data.frame}} to coerce the object to a \code{\link[base]{data.frame}},
  \item \code{\link[=as.matrix.FieldSet]{as.matrix}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the power, stopping probabilities, and expected sample size for testing 
the hazard ratio in a two treatment groups survival design.
}
\details{
At given design the function calculates the power, stopping probabilities, and expected 
sample size at given number of events and number of subjects. 
It also calculates the time when the required events are expected under the given 
assumptions (exponentially, piecewise exponentially, or Weibull distributed survival times 
and constant or non-constant piecewise accrual). 
Additionally, an allocation ratio = n1/n2 can be specified where n1 and n2 are the number 
of subjects in the two treatment groups. 
 
The formula of Kim & Tsiatis (Biometrics, 1990) 
is used to calculate the expected number of events under the alternative 
(see also Lakatos & Lan, Statistics in Medicine, 1992). These formulas are generalized to piecewise survival times and 
non-constant piecewise accrual over time.\cr
}
\section{Piecewise survival time}{

The first element of the vector \code{piecewiseSurvivalTime} must be equal to \code{0}. 
\code{piecewiseSurvivalTime} can also be a list that combines the definition of the 
time intervals and hazard rates in the reference group. 
The definition of the survival time in the treatment group is obtained by the specification 
of the hazard ratio (see examples for details).
}

\section{Staggered patient entry}{

\code{accrualTime} is the time period of subjects' accrual in a study. 
It can be a value that defines the end of accrual or a vector.
In this case, \code{accrualTime} can be used to define a non-constant accrual over time. 
For this, \code{accrualTime} is a vector that defines the accrual intervals. 
The first element of \code{accrualTime} must be equal to \code{0} and, additionally, 
\code{accrualIntensity} needs to be specified. 
\code{accrualIntensity} itself is a value or a vector (depending on the 
length of \code{accrualtime}) that defines the intensity how subjects 
enter the trial in the intervals defined through \code{accrualTime}.
 
\code{accrualTime} can also be a list that combines the definition of the accrual time and 
accrual intensity (see below and examples for details).

If the length of \code{accrualTime} and the length of \code{accrualIntensity} are the same 
(i.e., the end of accrual is undefined), \code{maxNumberOfSubjects > 0} needs to be specified  
and the end of accrual is calculated.
In that case, \code{accrualIntensity} is the number of subjects per time unit, i.e., the absolute accrual intensity.

If the length of \code{accrualTime} equals the length of \code{accrualIntensity - 1}   
(i.e., the end of accrual is defined), \code{maxNumberOfSubjects} is calculated if the absolute accrual intensity is given.
If all elements in \code{accrualIntensity} are smaller than 1, \code{accrualIntensity} defines 
the *relative* intensity how subjects enter the trial.
For example, \code{accrualIntensity = c(0.1, 0.2)} specifies that in the second accrual interval 
the intensity is doubled as compared to the first accrual interval. The actual (absolute) accrual intensity 
is calculated for the calculated or given \code{maxNumberOfSubjects}.
Note that the default is \code{accrualIntensity = 0.1} meaning that the *absolute* accrual intensity 
will be calculated.
}

\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of 
the \code{rpact} specific implementation of the generic. 
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and 
to identify the object specific name of it, e.g., 
use \code{methods("plot")} to get all the methods for the \code{plot} generic. 
There you can find, e.g., \code{plot.AnalysisResults} and 
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
# Fixed sample size with minimum required definitions, pi1 = c(0.4,0.5,0.5) and 
# pi2 = 0.2 at event time 12, accrual time 12 and follow-up time 6 as default 
getPowerSurvival(maxNumberOfEvents = 40, maxNumberOfSubjects = 200)
\donttest{
# Four stage O'Brien & Fleming group sequential design with minimum required 
# definitions, pi1 = c(0.4,0.5,0.5) and pi2 = 0.2 at event time 12, 
# accrual time 12 and follow-up time 6 as default  
getPowerSurvival(design = getDesignGroupSequential(kMax = 4), 
    maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# For fixed sample design, determine necessary accrual time if 200 subjects and 
# 30 subjects per time unit can be recruited 
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = c(0), 
    accrualIntensity = 30, maxNumberOfSubjects = 200)

# Determine necessary accrual time if 200 subjects and if the first 6 time units 
# 20 subjects per time unit can be recruited, then 30 subjects per time unit 
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = c(0, 6), 
    accrualIntensity = c(20, 30), maxNumberOfSubjects = 200)

# Determine maximum number of Subjects if the first 6 time units 20 subjects per 
# time unit can be recruited, and after 10 time units 30 subjects per time unit
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = c(0, 6, 10), 
    accrualIntensity = c(20, 30))

# Specify accrual time as a list
at <- list(
    "0 - <6"  = 20,
    "6 - Inf" = 30)
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = at, maxNumberOfSubjects = 200)

# Specify accrual time as a list, if maximum number of subjects need to be calculated
at <- list(
    "0 - <6"   = 20,
    "6 - <=10" = 30) 
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = at)

# Specify effect size for a two-stage group design with O'Brien & Fleming boundaries
# Effect size is based on event rates at specified event time, directionUpper = FALSE 
# needs to be specified because it should be shown that hazard ratio < 1
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), pi1 = 0.2, pi2 = 0.3, 
    eventTime = 24, maxNumberOfEvents = 40, maxNumberOfSubjects = 200, 
    directionUpper = FALSE)

# Effect size is based on event rate at specified event time for the reference group 
# and hazard ratio, directionUpper = FALSE needs to be specified 
# because it should be shown that hazard ratio < 1
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), hazardRatio = 0.5, 
    pi2 = 0.3, eventTime = 24, maxNumberOfEvents = 40, maxNumberOfSubjects = 200, 
    directionUpper = FALSE)

# Effect size is based on hazard rate for the reference group and hazard ratio, 
# directionUpper = FALSE needs to be specified because it should be shown that 
# hazard ratio < 1
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), hazardRatio = 0.5, 
    lambda2 = 0.02, maxNumberOfEvents = 40, maxNumberOfSubjects = 200, 
    directionUpper = FALSE) 

# Specification of piecewise exponential survival time and hazard ratios  
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), 
    piecewiseSurvivalTime = c(0, 5, 10), lambda2 = c(0.01,0.02,0.04), 
    hazardRatio = c(1.5, 1.8, 2),  maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# Specification of piecewise exponential survival time as list and hazard ratios 
pws <- list(
    "0 - <5"  = 0.01,
    "5 - <10" = 0.02,
    ">=10"    = 0.04)
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), 
    piecewiseSurvivalTime = pws, hazardRatio = c(1.5, 1.8, 2), 
    maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# Specification of piecewise exponential survival time for both treatment arms  
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), 
    piecewiseSurvivalTime = c(0, 5, 10), lambda2 = c(0.01, 0.02, 0.04), 
    lambda1 = c(0.015,0.03,0.06),  maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# Specification of piecewise exponential survival time as a list
pws <- list(
    "0 - <5"  = 0.01,
    "5 - <10" = 0.02,
    ">=10"    = 0.04)
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), 
    piecewiseSurvivalTime = pws, hazardRatio = c(1.5, 1.8, 2), 
    maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# Specify effect size based on median survival times
getPowerSurvival(median1 = 5, median2 = 3, 
    maxNumberOfEvents = 40, maxNumberOfSubjects = 200, directionUpper = FALSE)

# Specify effect size based on median survival times of 
# Weibull distribtion with kappa = 2
getPowerSurvival(median1 = 5, median2 = 3, kappa = 2, 
    maxNumberOfEvents = 40, maxNumberOfSubjects = 200, directionUpper = FALSE)
}

}
\seealso{
Other power functions: 
\code{\link{getPowerMeans}()},
\code{\link{getPowerRates}()}
}
\concept{power functions}
