% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_core_parameter_set.R
\name{plot.ParameterSet}
\alias{plot.ParameterSet}
\title{Parameter Set Plotting}
\usage{
\method{plot}{ParameterSet}(
  x,
  y,
  ...,
  main = NA_character_,
  xlab = NA_character_,
  ylab = NA_character_,
  type = 1L,
  palette = "Set1",
  legendPosition = NA_integer_,
  showSource = FALSE,
  plotSettings = NULL
)
}
\arguments{
\item{x}{The object that inherits from \code{\link{ParameterSet}}.}

\item{y}{Not available for this kind of plot (is only defined to be compatible to the generic plot function).}

\item{...}{Optional plot arguments. At the moment \code{xlim} and \code{ylim} are implemented 
for changing x or y axis limits without dropping data observations.}

\item{main}{The main title.}

\item{xlab}{The x-axis label.}

\item{ylab}{The y-axis label.}

\item{type}{The plot type (default = 1).}

\item{palette}{The palette, default is \code{"Set1"}.}

\item{legendPosition}{The position of the legend. 
By default (\code{NA_integer_}) the algorithm tries to find a suitable position. 
Choose one of the following values to specify the position manually:
\itemize{
  \item \code{-1}: no legend will be shown
  \item \code{NA}: the algorithm tries to find a suitable position
  \item \code{0}: legend position outside plot
  \item \code{1}: legend position left top
  \item \code{2}: legend position left center
  \item \code{3}: legend position left bottom
  \item \code{4}: legend position right top
  \item \code{5}: legend position right center
  \item \code{6}: legend position right bottom
}}

\item{showSource}{Logical. If \code{TRUE}, the parameter names of the object will 
be printed which were used to create the plot; that may be, e.g., 
useful to check the values or to create own plots with the base R \code{plot} function.
Alternatively \code{showSource} can be defined as one of the following character values: 
\itemize{
  \item \code{"commands"}: returns a character vector with plot commands
  \item \code{"axes"}: returns a list with the axes definitions
  \item \code{"test"}: all plot commands will be validated with \code{eval(parse())} and 
        returned as character vector (function does not stop if an error occurs)
  \item \code{"validate"}: all plot commands will be validated with \code{eval(parse())} and 
        returned as character vector (function stops if an error occurs)
}
Note: no plot object will be returned if \code{showSource} is a character.}

\item{plotSettings}{An object of class \code{PlotSettings} created by \code{\link[=getPlotSettings]{getPlotSetting()s}}.}
}
\value{
Returns a \code{ggplot2} object.
}
\description{
Plots an object that inherits from class \code{\link{ParameterSet}}.
}
\details{
Generic function to plot a parameter set.
}
