% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_plan_rates.R
\name{getPowerRates}
\alias{getPowerRates}
\title{Get Power Rates}
\usage{
getPowerRates(
  design = NULL,
  ...,
  groups = 2L,
  riskRatio = FALSE,
  thetaH0 = ifelse(riskRatio, 1, 0),
  pi1 = seq(0.2, 0.5, 0.1),
  pi2 = 0.2,
  directionUpper = NA,
  maxNumberOfSubjects = NA_real_,
  allocationRatioPlanned = NA_real_
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used.
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower},
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{groups}{The number of treatment groups (1 or 2), default is \code{2}.}

\item{riskRatio}{If \code{TRUE}, the power for one-sided
testing of H0: \code{pi1 / pi2 = thetaH0} is calculated, default is \code{FALSE}.}

\item{thetaH0}{The null hypothesis value,
default is \code{0} for the normal and the binary case (testing means and rates, respectively),
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
\item \emph{means}: a value \code{!= 0}
(or a value \code{!= 1} for testing the mean ratio) can be specified.
\item \emph{rates}: a value \code{!= 0}
(or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
\item \emph{survival data}: a bound for testing H0: \code{hazard ratio = thetaH0 != 1} can be specified.
\item \emph{count data}: a bound for testing H0: \code{lambda1 / lambda2 = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for
defining the null hypothesis H0: \code{pi = thetaH0}.}

\item{pi1}{A numeric value or vector that represents the assumed probability in
the active treatment group if two treatment groups
are considered, or the alternative probability for a one treatment group design,
default is \code{seq(0.2, 0.5, 0.1)} (power calculations and simulations) or
\code{seq(0.4, 0.6, 0.1)} (sample size calculations).}

\item{pi2}{A numeric value that represents the assumed probability in the reference group if two treatment
groups are considered, default is \code{0.2}.}

\item{directionUpper}{Logical. Specifies the direction of the alternative,
only applicable for one-sided testing; default is \code{TRUE}
which means that larger values of the test statistics yield smaller p-values.}

\item{maxNumberOfSubjects}{\code{maxNumberOfSubjects > 0} needs to be specified for power calculations or calculation
of necessary follow-up (count data). For two treatment arms, it is the maximum number of subjects for both treatment arms.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups
design, default is \code{1}. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control.
For simulating means and rates for a two treatment groups design, it can be a vector of length \code{kMax}, the number of stages.
It can be a vector of length kMax, too, for multi-arm and enrichment designs.
In these cases, a change of allocating subjects to treatment groups over the stages can be assessed.
Note that internally \code{allocationRatioPlanned} is treated as a vector of length \code{kMax}, not a scalar.}
}
\value{
Returns a \code{\link{TrialDesignPlan}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.TrialDesignSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.TrialDesignPlan]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.TrialDesignPlan]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the power, stopping probabilities, and expected sample size for testing rates
in one or two samples at given maximum sample size.
}
\details{
At given design the function calculates the power, stopping probabilities, and expected sample size
for testing rates at given maximum sample size.
The sample sizes over the stages are calculated according to the specified information rate in the design.
In a two treatment groups design, additionally, an allocation ratio = \code{n1 / n2} can be specified
where \code{n1} and \code{n2} are the number of subjects in the two treatment groups.
If a null hypothesis value thetaH0 != 0 for testing the difference of two rates
or \code{thetaH0 != 1} for testing the risk ratio is specified, the
formulas according to Farrington & Manning (Statistics in Medicine, 1990) are used (only one-sided testing).
Critical bounds and stopping for futility bounds are provided at the effect scale
(rate, rate difference, or rate ratio, respectively).
For the two-sample case, the calculation here is performed at fixed pi2 as given as argument in the function.
Note that the power calculation for rates is always based on the normal approximation.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
# Calculate the power, stopping probabilities, and expected sample size in a
# two-armed design at given maximum sample size N = 200 in a three-stage 
# O'Brien & Fleming design with information rate vector (0.2,0.5,1), 
# non-binding futility boundaries (0,0), i.e., the study stops for futility 
# if the p-value exceeds 0.5 at interm, and allocation ratio = 2 for a range 
# of pi1 values when testing H0: pi1 - pi2 = -0.1:
getPowerRates(getDesignGroupSequential(informationRates = c(0.2, 0.5, 1), 
    futilityBounds = c(0, 0)), groups = 2, thetaH0 = -0.1, 
    pi1 = seq(0.3, 0.6, 0.1), directionUpper = FALSE, 
    pi2 = 0.7, allocationRatioPlanned = 2, maxNumberOfSubjects = 200)
\dontrun{
# Calculate the power, stopping probabilities, and expected sample size in a single 
# arm design at given maximum sample size N = 60 in a three-stage two-sided 
# O'Brien & Fleming design with information rate vector (0.2, 0.5,1) 
# for a range of pi1 values when testing H0: pi = 0.3:
getPowerRates(getDesignGroupSequential(informationRates = c(0.2, 0.5,1), 
    sided = 2), groups = 1, thetaH0 = 0.3, pi1 = seq(0.3, 0.5, 0.05),  
    maxNumberOfSubjects = 60)
}

}
\seealso{
Other power functions: 
\code{\link{getPowerCounts}()},
\code{\link{getPowerMeans}()},
\code{\link{getPowerSurvival}()}
}
\concept{power functions}
