% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpcmp.R
\name{rpf.gpcmp}
\alias{rpf.gpcmp}
\title{Create monotonic polynomial generalized partial credit (GPC-MP) model}
\usage{
rpf.gpcmp(outcomes = 2, q = 0, multidimensional = FALSE)
}
\arguments{
\item{outcomes}{The number of possible response categories.}

\item{q}{a non-negative integer that controls the order of the
polynomial (2q+1) with a default of q=0 (1st order polynomial = generalized partial credit model).}

\item{multidimensional}{whether to use a multidimensional model.
Defaults to \code{FALSE}. The multidimensional version is not yet
available.}
}
\value{
an item model
}
\description{
This model is a polytomous model proposed by Falk & Cai (2016) and is based
on the generalized partial credit model (Muraki, 1992).
}
\details{
The GPC-MP replaces the linear predictor part of the
generalized partial credit model with a monotonic polynomial,
\eqn{m(\theta;\omega,\xi,\mathbf{\alpha},\mathbf{\tau})}{m(theta; omega, alpha, tau)}.
The response function for category k is:

\deqn{\mathrm P(\mathrm{pick}=k|\omega,\xi,\alpha,\tau,\theta)
= \frac{\exp(\sum_{v=0}^k (\xi_k + m(\theta;\omega,\xi,\mathbf{\alpha},\mathbf{\tau})))}{\sum_{u=0}^{K-1}\exp(\sum_{v=0}^u (\xi_u + m(\theta;\omega,\xi,\mathbf{\alpha},\mathbf{\tau})))}
}{\frac{exp(sum_{v=0}^k (xi_k + m(theta;omega,xi,alpha,tau)))}{sum_{u=0}^{K-1}exp(sum_{v=0}^u (xi_u + m(theta;omega,xi,alpha,tau)))}}

where \eqn{\mathbf{\alpha}}{alpha} and \eqn{\mathbf{\tau}}{tau} are vectors
of length q. The GPC-MP uses the same parameterization for the polynomial
as described for the logistic function of a monotonic polynomial (LMP).
See also (\code{\link{rpf.lmp}}).

The order of the polynomial is always odd and is controlled by
the user specified non-negative integer, q. The model contains
1+(outcomtes-1)+2*q parameters and are used as input to the \code{\link{rpf.prob}}
function in the following order:
\eqn{\omega}{omega} - natural log of the slope of the item model when q=0,
\eqn{\xi}{xi} - a (outcomes-1)-length vector of intercept parameters,
\eqn{\alpha}{alpha} and \eqn{\tau}{tau} - two parameters that control bends in
the polynomial. These latter parameters are repeated in the same order for
models with q>0. For example, a q=2 polynomial with 3 categories will have an item
parameter vector of: \eqn{\omega, \xi_1, \xi_2, \alpha_1, \tau_1, \alpha_2, \tau_2}{
omega, xi1, xi2, alpha1, tau1, alpha2, tau2}.

Note that the GPC-MP reduces to the LMP when the number of
categories is 2, and the GPC-MP reduces to the generalized partial
credit model when the order of the polynomial is 1 (i.e., q=0).
}
\examples{
spec <- rpf.gpcmp(5,2) # 5-category, 3rd order polynomial
theta<-seq(-3,3,.1)
p<-rpf.prob(spec, c(1.02,3.48,2.5,-.25,-1.64,.89,-8.7,-.74,-8.99),theta)

}
\references{
Falk, C. F., & Cai, L. (2016). Maximum marginal likelihood
estimation of a monotonic polynomial generalized partial credit model with
applications to multiple group analysis. \emph{Psychometrika, 81}, 434-460.
\url{http://dx.doi.org/10.1007/s11336-014-9428-7}

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm. \emph{Applied Psychological Measurement, 16,} 159–176.
}
\seealso{
Other response model: 
\code{\link{rpf.drm}()},
\code{\link{rpf.grmp}()},
\code{\link{rpf.grm}()},
\code{\link{rpf.lmp}()},
\code{\link{rpf.mcm}()},
\code{\link{rpf.nrm}()}
}
\concept{response model}
