% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpg.R
\name{write_table}
\alias{write_table}
\alias{read_table}
\title{PostgreSQL data frame IO}
\usage{
write_table(x, tablename, pkey = NULL, row_names = NULL,
  schemaname = NULL, types = NULL, append = FALSE, overwrite = FALSE)

read_table(tablename, what = "*", limit = NULL, row_names = NULL,
  schemaname = NULL, pkey_to_row_names = FALSE)
}
\arguments{
\item{x}{a data frame or something convertible to a data frame}

\item{tablename}{the name of the table to read from or write to}

\item{pkey}{a column name to use as primary key}

\item{row_names}{a column name to write row names}

\item{schemaname}{the schema name}

\item{types}{a list of valid PostgreSQL type names}

\item{append}{if true, append rows to existing table}

\item{overwrite}{if true, destroy existing table with the same name}

\item{what}{a vector of column names}

\item{limit}{only return this many rows}

\item{pkey_to_row_names}{if true and row_names not given, use primary key column}
}
\value{
\code{write_table} the final query status

\code{read_table} a data frame
}
\description{
Reads and writes table to and from database
}
\details{
A table is created using the current connection. If \code{pkey} does not
match any column name, then a new column is created with the name given by
\code{pkey}. Its type will be \code{serial} and it will be set as the primary
key. If \code{pkey} does match an existing column name, then that column will
be used as the primary key. Note that \code{\link{make.unique}} will be
called on the column names before this matching is done. If \code{row_names}
is a character string, the data frame row names will be stored in a column
with the column name given by \code{row_names}. The \code{row_names} column
can also be the primary key if \code{pkey} is the same as \code{row_names}.

If \code{row_names} is specified when calling \code{read_table}, then the
resulting data frame will have row names installed from the column named
in \code{row_names}. Note that the column named in \code{row_names} must
match a column specified by \code{what}. The matching column will be removed
from the data frame.

If \code{types} is not supplied, they will be computed from the classes and
types of the columns of input.
}
\note{
The entire process is wrapped within a transcation. On failure
at any point, the transaction will be rolled back and the database
unaffected.

Also, \code{write_table} uses SQL \code{INSERT} statements and as such
will be slow for large tables. You are much better off bulk loading data
using the \code{COPY} command outside of \code{R}.
}
\examples{
\dontrun{
# connect using defaults
createdb("rpgtesting")
connect("rpgtesting")
begin()
 
# write data frame contents
data(mtcars)
write_table(mtcars)

# make "cyl" primary key (will fail unique constraint)
write_table(mtcars, pkey = "cyl", overwrite = TRUE)

# also write row names to "id"
write_table(mtcars, row_names = "id", overwrite = TRUE)

# row names as primary key
write_table(mtcars, row_names = "id", pkey = "id", overwrite = TRUE)

# default R row names and only first 3 columns
read_table("mtcars", what = "mpg, cyl, disp", limit = 3)

# row names from column "id"
read_table("mtcars", row_names = "id", limit = 3)

# get row names from primary key
read_table("mtcars", pkey_to_row_names = TRUE, limit = 3)

#cleanup
rollback()
disconnect()
dropdb("rpgtesting")}

}
\seealso{
\code{\link{copy_from}}
}
\author{
Timothy H. Keitt
}
