% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feat.R
\name{add.UTRs.feat}
\alias{add.UTRs.feat}
\title{Add UTRs to features}
\usage{
add.UTRs.feat(x)
}
\arguments{
\item{x}{An object of type \code{feat}.  CDS regions must be present with type "CDS", and
the transcript_id must be indicated in the attribute field.}
}
\value{
An object of type \code{feat}, with all the entries of the original object, but
also with UTR annotations.
}
\description{
Add UTRs to features
}
\note{
If x is stored as a pointer to an object stored in C, then UTRs will be added
to x.
}
\examples{
exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
featFile <- "gencode.ENr334.gp"
unzip(exampleArchive, featFile)
f <- read.feat(featFile)
table(f$feature)
coverage.feat(f[f$feature=="CDS",])
coverage.feat(f[f$feature=="exon",])
f <- add.UTRs.feat(f)
table(f$feature)
coverage.feat(f[f$feature=="3'UTR",])
coverage.feat(f[f$feature=="5'UTR",])
unlink(featFile)
}
\author{
Melissa J. Hubisz and Adam Siepel
}
\keyword{features}

