% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_images.R
\name{search_images}
\alias{search_images}
\title{Search for images for a taxon (via its uuid)}
\usage{
search_images(uuid, subtaxa = NULL, supertaxa = NULL, other = NULL,
  options = NULL, cleanoutput = TRUE, ...)
}
\arguments{
\item{uuid}{(character) one or more UUIDs of taxonomic names}

\item{subtaxa}{If set to \code{TRUE}, includes subtaxa in the search.}

\item{supertaxa}{If not set to \code{FALSE}, includes supertaxa in the search.}

\item{other}{If set to \code{TRUE}, includes related taxa in the search.}

\item{options}{Space-separated list of options for the result value.}

\item{cleanoutput}{If \code{TRUE}, remove elements with no data.}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Search for images for a taxon (via its uuid)
}
\examples{
\dontrun{
search_images('1ee65cf3-53db-4a52-9960-a9f7093d845d', 
  subtaxa = "true", options = c("pngFiles", "credit", "licenseURL", 
  "svgFile", "canonicalName", "html"))

# all of them
search_images(c("1ee65cf3-53db-4a52-9960-a9f7093d845d",
   "08141cfc-ef1f-4d0e-a061-b1347f5297a0"), 
   options=c("pngFiles", "credit", "canonicalName"))
}
}
