% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_uuid.R
\name{get_uuid}
\alias{get_uuid}
\title{Get a PhyloPic uuid}
\usage{
get_uuid(name = NULL, n = 1, url = FALSE)
}
\arguments{
\item{name}{\code{character}. A taxonomic name. Various taxonomic levels
are supported (e.g. species, genus, family). NULL can also be supplied
which will skip the taxonomic filtering of the PhyloPic database.}

\item{n}{\code{numeric}. How many uuids should be returned? Depending on
the requested \code{name}, multiple silhouettes might exist. If \code{n} exceeds
the number of available images, all available uuids will be returned.
This argument defaults to 1.}

\item{url}{\code{logical}. If \code{FALSE} (default), only the uuid is
returned. If \code{TRUE}, a valid PhyloPic image url of the uuid is
returned.}
}
\value{
A \code{character} vector of a valid PhyloPic uuid or svg image
url.
}
\description{
This function provides a convenient way to obtain a valid uuid or image url
for an input taxonomic name. As multiple silhouettes can exist for each
species in PhyloPic, this function extracts the primary image.
}
\details{
This function returns uuid(s) or image url (svg) for an input
\code{name}. If a specific image is desired, the user can make use of
\link{pick_phylopic} to visually select the desired uuid/url.
}
\examples{
uuid <- get_uuid(name = "Acropora cervicornis")
uuid <- get_uuid(name = "Dinosauria", n = 5, url = TRUE)
}
