% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_phylopic.r
\name{add_phylopic}
\alias{add_phylopic}
\title{Annotate a ggplot plot with PhyloPics}
\usage{
add_phylopic(
  img = NULL,
  name = NULL,
  uuid = NULL,
  x,
  y,
  ysize = Inf,
  alpha = 1,
  color = "black",
  horizontal = FALSE,
  vertical = FALSE,
  angle = 0,
  remove_background = TRUE
)
}
\arguments{
\item{img}{A \link[grImport2:Picture-class]{Picture} or png array object, e.g.,
from using \code{\link[=get_phylopic]{get_phylopic()}}.}

\item{name}{\code{character}. A taxonomic name to be passed to \code{\link[=get_uuid]{get_uuid()}}.}

\item{uuid}{\code{character}. A valid uuid for a PhyloPic silhouette (such as
that returned by \code{\link[=get_uuid]{get_uuid()}} or \code{\link[=pick_phylopic]{pick_phylopic()}}).}

\item{x}{\code{numeric}. x value of the silhouette center.}

\item{y}{\code{numeric}. y value of the silhouette center.}

\item{ysize}{\code{numeric}. Height of the silhouette. The width is
determined by the aspect ratio of the original image. If "Inf", the
default, the height will be as tall as will fit within the plot area.}

\item{alpha}{\code{numeric}. A value between 0 and 1, specifying the opacity
of the silhouette (0 is fully transparent, 1 is fully opaque).}

\item{color}{\code{character}. Color to plot the silhouette in. If "original"
is specified, the original color of the silhouette will be used (usually
the same as "black").}

\item{horizontal}{\code{logical}. Should the silhouette be flipped
horizontally?}

\item{vertical}{\code{logical}. Should the silhouette be flipped vertically?}

\item{angle}{\code{numeric}. The number of degrees to rotate the silhouette
clockwise. The default is no rotation.}

\item{remove_background}{\code{logical}. Should any white background be
removed from the silhouette(s)? See \code{\link[=recolor_phylopic]{recolor_phylopic()}} for details.}
}
\description{
Specify existing images, taxonomic names, or PhyloPic uuids to add PhyloPic
silhouettes as a separate layer to an existing ggplot plot.
}
\details{
One (and only one) of \code{img}, \code{name}, or \code{uuid} must be specified.
Use parameters \code{x}, \code{y}, and \code{ysize} to place the silhouette at a specified
position on the plot. The aspect ratio of the silhouette will always be
maintained.

\code{x} and/or \code{y} may be vectors of numeric values if multiple silhouettes
should be plotted at once. In this case, any other arguments (except for
\code{remove_background}) may also be vectors of values, which will be recycled
as necessary.

When specifying a horizontal and/or vertical flip \strong{and} a rotation, the
flip(s) will always occur first. If you would like to customize this
behavior, you can flip and/or rotate the image within your own workflow
using \code{\link[=flip_phylopic]{flip_phylopic()}} and \code{\link[=rotate_phylopic]{rotate_phylopic()}}.

Note that png array objects can only be rotated by multiples of 90 degrees.
}
\examples{
# Put a silhouette behind a plot based on a taxonomic name
library(ggplot2)
ggplot(iris) +
  add_phylopic(x = 6.1, y = 3.2, name = "Iris", alpha = 0.2) +
  geom_point(aes(x = Sepal.Length, y = Sepal.Width))

# Put a silhouette in several places based on UUID
posx <- runif(10, 0, 10)
posy <- runif(10, 0, 10)
sizey <- runif(10, 0.4, 2)
angle <- runif(10, 0, 360)
hor <- sample(c(TRUE, FALSE), 10, TRUE)
ver <- sample(c(TRUE, FALSE), 10, TRUE)
cols <- sample(c("black", "darkorange", "grey42", "white"), 10,
  replace = TRUE)
alpha <- runif(10, 0.3, 1)

p <- ggplot(data.frame(cat.x = posx, cat.y = posy), aes(cat.x, cat.y)) +
  geom_blank() +
  add_phylopic(uuid = "23cd6aa4-9587-4a2e-8e26-de42885004c9",
               x = posx, y = posy, ysize = sizey,
               color = cols, alpha = alpha, angle = angle,
               horizontal = hor, vertical = ver)
p + ggtitle("R Cat Herd!!")
}
