% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plosviews.R
\name{plosviews}
\alias{plosviews}
\title{Search PLoS Journals by article views.}
\usage{
plosviews(search, byfield = NULL, views = "alltime", limit = NULL, ...)
}
\arguments{
\item{search}{search terms (character)}

\item{byfield}{field to search by, e.g., subject, author, etc. (character)}

\item{views}{views all time (alltime) or views last 30 days (last30)
(character)}

\item{limit}{number of results to return (integer)}

\item{...}{Optional additional curl options passed to 
\code{\link[crul]{HttpClient}}}
}
\description{
Search PLoS Journals by article views.
}
\examples{
\dontrun{
plosviews('10.1371/journal.pone.0002154', 'id', 'alltime')
plosviews('10.1371/journal.pone.0002154', 'id', 'last30')
plosviews('10.1371/journal.pone.0002154', 'id', 'alltime,last30')
plosviews(search='marine ecology', byfield='subject', limit=50)
plosviews(search='evolution', views = 'alltime', limit = 99)
plosviews('bird', views = 'alltime', limit = 99)
}
}
