% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfun_rpm_0_1.R
\name{node_plot}
\alias{node_plot}
\alias{rpms::node_plot}
\title{node_plot}
\usage{
node_plot(t1, node, data, variable = NA, ...)
}
\arguments{
\item{t1}{\code{rpms} object}

\item{node}{integer label of the desired end-node.}

\item{data}{data.frame that includes variables used in rp_equ, e_equ, 
and design information}

\item{variable}{string name of variable in data to use as x-axis in plot}

\item{...}{further arguments passed to plot function.}
}
\description{
plots end-node of object of class \code{rpms}
}
\examples{
{

# model linear fit between retirement contributions and amount of income 
r1 <-rpms(FINDRETX~EDUC_REF+AGE_REF+BLS_URBN+REGION, data=CE,
     e_equ=FINDRETX~FINCBTAX, clusters=~CID) 

# plot node 2
node_plot(r1, node=2, data=CE)

#' # plot node 7
node_plot(r1, node=7, data=CE)


\dontrun{node_plot(r1, node=11, data=CE)}

}

}

