% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pnfprocessor.R
\name{pnfprocessor}
\alias{pnfprocessor}
\title{Generate all point and figure informations for a given time series.}
\usage{
pnfprocessor(high, low = high, date, reversal = 3L, boxsize = 1L,
  log = FALSE, style = "xo")
}
\arguments{
\item{high}{a vector containing the high quotes}

\item{low}{a (optional) vector containing the low quotes}

\item{date}{a vector of dates the quotes belong}

\item{reversal}{number of boxes needed to make a reversal}

\item{boxsize}{the boxsize to be used}

\item{log}{should we do the calculations on a logarithmic scale}

\item{style}{the style the pnfprocessor is working with. Can be \{xo,rs,bp\}.}
}
\value{
returns a data table with all point and figure information in it
}
\description{
Please ensure that high, low and date are all ordered according to the Date column.
}
\examples{
library(rpnf) # Load rpnf library
data(DOW) # (Offline) Load free available sample data from https://www.quandl.com/data/WIKI/DOW
pnfdata <- pnfprocessor(
  high=DOW$High,
  low=DOW$Low,
  date=DOW$Date,
  boxsize=1L,
  log=FALSE)
pnfdata
}
\references{
\url{http://rpnf.r-forge.r-project.org}
}
\seealso{
\code{\link{pnfplot}}

\code{\link{pnfplottxt}}
}

