% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_db_wrapper_fns.R
\name{dbTableInfo}
\alias{dbTableInfo}
\title{Get information about table columns.}
\usage{
dbTableInfo(conn, name, allinfo = FALSE)
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database.}

\item{name}{A character string specifying a PostgreSQL schema (if
necessary), and table or view name (e.g., \code{name
= c("schema", "table")}).}

\item{allinfo}{Logical, Get all information on table? Default is
column names, types, nullable, and maximum length of character
columns.}
}
\value{
data frame
}
\description{
Get information about columns in a PostgreSQL table.
}
\examples{
\dontrun{
dbTableInfo(conn, c("schema", "table"))
}
}
\author{
David Bucklin \email{david.bucklin@gmail.com}
}
