% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explorePgtraj.R
\name{explorePgtraj}
\alias{explorePgtraj}
\title{Explore a pgtraj interactively in a Shiny app}
\usage{
explorePgtraj(conn, schema, pgtraj, layer_vector = NULL,
  layer_param_vector = NULL, layer_raster = NULL,
  layer_param_raster = NULL)
}
\arguments{
\item{conn}{DBI::DBIConnection}

\item{schema}{String. Schema name of the pgtraj.}

\item{pgtraj}{String. Pgtraj name.}

\item{layer_vector}{List of character vectors. As c(schema, table).}

\item{layer_param_vector}{Named list of lists. Names need to map to the
table names in layer_vector. Sub-lists contain parameters passed to
leaflet::add*. See example.}

\item{layer_raster}{raster::RasterLayer object}

\item{layer_param_raster}{List. Parameters passed to leaflet::addRasterImage()}
}
\value{
nothing
}
\description{
See vignette for details.
}
\examples{
\dontrun{
# Vectore base layers to include
layer_vector <- list(c("example_data", "county_subdiv"),
                      c("example_data", "test_points")
                      )
layer_param_vector <- list(test_points=list(color = "red",
                                              stroke = FALSE,
                                              fillOpacity = 0.5),
                             county_subdiv=list(color = "grey",
                                                fillOpacity = 0.2)
                             )

# Raster base layers to include
ras <- rgdal::readGDAL("./temp_data/florida_dem_county099.tif")
ras2 <- raster::raster(ras, 1)
ras2_leaflet <- leaflet::projectRasterForLeaflet(ras2)
explorePgtraj(conn, schema, pgtraj, layer_vector, layer_param_vector,
              layer_raster=ras2_leaflet)
}
}
\author{
Balázs Dukai \email{balazs.dukai@gmail.com}
}
