% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inc_model.R
\name{draw_incident_population}
\alias{draw_incident_population}
\title{Simulates an incident population according to a specific incidence model}
\usage{
draw_incident_population(object, data, timeframe, covars)
}
\arguments{
\item{object}{The incidence model.}

\item{data}{The original registry data frame passed into \code{prevalence}. It
is supplied in this method so that individual level attributes can be
sampled from the prior distribution.}

\item{timeframe}{The amount of time in days in which to simulate incidence
for.}

\item{covars}{Any patient level covariates that must be included in the
new simulated incident population, as a character vector. These will 
correspond to columns in \code{data}.}
}
\value{
A data frame where each row corresponds to a simulate incident
  patient. The first column must be incidence time (in days). This
  will be relative to an unspecified baseline. All covariates specified
  in \code{covars} must be present in this data frame.
}
\description{
This method defines the main behaviour of an incidence model and must be
implemented for any class to be used in \code{prevalence}.
}
