% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motion_correction.R
\name{ants_motion_correction}
\alias{ants_motion_correction}
\title{Motion correction}
\usage{
ants_motion_correction(
  x,
  fixed = NULL,
  type_of_transform = "BOLDRigid",
  mask = NULL,
  fdOffset = 50,
  outprefix = "",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{input image, usually 'fMRI' series}

\item{fixed}{fixed image to register all timepoints to}

\item{type_of_transform}{see \code{\link{ants_registration}}}

\item{mask}{mask for image}

\item{fdOffset}{offset value to use in frame-wise displacement calculation}

\item{outprefix}{save path}

\item{verbose}{whether to verbose the messages}

\item{...}{passed to registration methods}
}
\value{
Motion-corrected image
}
\description{
Print \code{ants$motion_correction} to see the original document
}
\examples{

if(interactive() && ants_available()) {
  fi <- as_ANTsImage(ants$get_ants_data('ch2'))
  mytx <- ants_motion_correction( fi )

  par(mfrow = c(1, 2), mar = c(1,1,1,1))
  image(fi[,,91], asp = 1, axes = FALSE)
  image(mytx$motion_corrected[,,91], asp = 1, axes = FALSE)
}

}
