% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Order.R
\docType{class}
\name{Order-class}
\alias{Order-class}
\alias{Order}
\title{Class "Order"}
\description{
Class \code{Order} is responsible for creating assessment task according
to QTI 2.1., where candidate has to place answers in a specific order
}
\section{Slots}{

\describe{
\item{\code{identifier}}{A character representing the unique identifier of the
assessment task. By default, it is generated as 'id_task_dddd', where dddd
represents random digits.}

\item{\code{title}}{A character representing the title of the XML file associated
with the task. By default, it takes the value of the identifier.}

\item{\code{content}}{A list of character content to form the text of the question,
which can include HTML tags. For tasks of the \link{Entry} type, it must also
contain at least one instance of Gap objects, such as \linkS4class{TextGap},
\link{NumericGap}, or \link{InlineChoice}.}

\item{\code{prompt}}{An optional character representing a simple question text,
consisting of one paragraph. This can supplement or replace content in the
task. Default is "".}

\item{\code{points}}{A numeric value, optional, representing the number of points for
the entire task. Default is 1, but pay attention:
\itemize{
\item For tasks of the \link{Entry} type, it is
calculated as the sum of the gap points by default.
\item For tasks of the \link{MatchTable} type, it can also be calculated as the sum
of points for individual answers, when provided.
\item For tasks of the \link{MultipleChoice} type, points is numeric vector and
required. Each number in this vector determines the number of points that
will be awarded to a candidate if they select the corresponding answer. The
order of the scores must match the order of the \code{choices}. It is possible
to assign negative values to incorrect answers. All answers with a
positive score are considered correct.
}}

\item{\code{feedback}}{A list containing feedback messages for candidates. Each
element of the list should be an instance of either \link{ModalFeedback},
\link{CorrectFeedback}, or \link{WrongFeedback} class.}

\item{\code{calculator}}{A character, optional, determining whether to show a
calculator to the candidate. Possible values:
\itemize{
\item "simple-calculator"
\item "scientific-calculator"
}}

\item{\code{files}}{A character vector, optional, containing paths to files that will
be accessible to the candidate during the test/exam.}

\item{\code{qti_version}}{A character representing the QTI (Question and Test
Interoperability) information model version. Default is 'v2p1'.}

\item{\code{choices}}{A character vector containing the answers. The order of answers
in the vector represents the correct response for the task.}

\item{\code{choices_identifiers}}{A character vector, optional, containing a set of
identifiers for answers. By default, identifiers are generated
automatically. By default, identifiers are generated automatically
according to the template "ChoiceL", where L is a letter representing the
alphabetical order of the answer in the list.}

\item{\code{shuffle}}{A boolean value indicating whether to randomize the order in which
the choices are initially presented to the candidate. Default is TRUE.}

\item{\code{points_per_answer}}{A boolean value indicating the scoring method.
If \code{TRUE}, each selected answer will be scored individually.
If \code{FALSE}, only fully correct answers will be scored with the maximum score.
Default is \code{TRUE}.}
}}

\examples{
ord <- new("Order",
           identifier = "id_task_1234",
           title = "order",
           content = list("<p>Put these items in a right order</p>"),
           prompt = "",
           points = 2,
           feedback = list(),
           choices = c("first", "second", "third"),
           choices_identifiers = c("ChoiceA", "ChoiceB", "ChoiceC"),
           shuffle = TRUE,
           points_per_answer = TRUE)
}
