% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend.R
\name{extend_nse}
\alias{extend_nse}
\title{Extend data by adding more columns.}
\usage{
extend_nse(source, ..., partitionby = NULL, orderby = NULL, desc = FALSE,
  env = parent.frame())
}
\arguments{
\item{source}{source to select from.}

\item{...}{new column assignment expressions.}

\item{partitionby}{partitioning (window function) terms.}

\item{orderby}{ordering (window function) terms.}

\item{desc}{reverse order}

\item{env}{environment to look for values in.}
}
\value{
extend node.
}
\description{
Create a node similar to a Codd extend relational operator (add derived columns).
}
\details{
Allows re-use of column names in the spirit of \code{\link[seplyr]{partition_mutate_qt}},
though re-use can break relational property.
partitionby and orderby can only be used with a database that supports window-functions
(such as PostgreSQL).
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d <- dbi_copy_to(my_db, 'd',
                data.frame(AUC = 0.6, R2 = 0.2))
eqn <- extend_nse(d, v := ifelse(AUC>0.5, R2, 1.0))
cat(format(eqn))
sql <- to_sql(eqn, my_db)
cat(sql)
DBI::dbGetQuery(my_db, sql)
DBI::dbDisconnect(my_db)

}
