% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materialize.R
\name{materialize_node}
\alias{materialize_node}
\title{Create a materialize node.}
\usage{
materialize_node(source, ...,
  outgoing_table_name = mk_tmp_name_source("mout")(), overwrite = TRUE,
  temporary = TRUE)
}
\arguments{
\item{source}{incoming source (relop node or data.frame).}

\item{...}{force later arguments to be by name}

\item{outgoing_table_name}{character, name of table to write.}

\item{overwrite}{logical, if TRUE overwrite tables}

\item{temporary}{logical, if TRUE use temporary tables}
}
\value{
rsummary node
}
\description{
Create a materialize node.
}
\examples{

 d <- data.frame(p= c(TRUE, FALSE, NA),
                 s= NA,
                 w= 1:3,
                 x= c(NA,2,3),
                 y= factor(c(3,5,NA)),
                 z= c('a',NA,'a'),
                 stringsAsFactors=FALSE)
 db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
 RSQLite::initExtension(db)
 DBI::dbWriteTable(db, "dRemote", d,
                   overwrite = TRUE,
                   temporary = TRUE)

 ops <- dbi_table(db, "dRemote") \%.>\%
   extend_nse(., v := ifelse(x>2, "x", "y")) \%.>\%
   materialize_node(., outgoing_table_name = "intermediate") \%.>\%
   extend_nse(., v2 := ifelse(x>2, "x", "y"))
 cat(format(ops))

 to_sql(ops, db)

 reshdl <- materialize(db, ops)
 DBI::dbGetQuery(db, to_sql(reshdl, db))

 DBI::dbGetQuery(db, "SELECT * FROM intermediate")

 DBI::dbDisconnect(db)

}
\seealso{
\code{\link{execute}}, \code{\link{materialize}}, \code{\link{non_sql_node}}
}
