% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_sql_node.R
\name{non_sql_node}
\alias{non_sql_node}
\title{Wrap a non-SQL node.}
\usage{
non_sql_node(source, f, ..., incoming_table_name, columns_used,
  outgoing_table_name, columns_produced, display_form, orig_columns = TRUE,
  temporary = TRUE)
}
\arguments{
\item{source}{source to work from (data.frame or relop node)}

\item{f}{implementation signature: f(db, incoming_table_name, outgoing_table_name)}

\item{...}{force later arguments to bind by name}

\item{incoming_table_name}{character, name of incoming table}

\item{columns_used}{character, incoming columns used}

\item{outgoing_table_name}{character, name of produced table}

\item{columns_produced}{character, names of columns produced}

\item{display_form}{chacter, how to print node}

\item{orig_columns}{logical if TRUE select all original columns.}

\item{temporary}{logical, if TRUE mark tables temporary.}
}
\value{
sql node.
}
\description{
Note: non-SQL nodes are allowed to delete/overwrite both
both the incoming and outgoing tables, so do not point them
to non-temporary structures.
}
\seealso{
\code{\link{rsummary_node}}
}
