% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremum.R
\name{extremum}
\alias{extremum}
\alias{rray_maximum}
\alias{rray_minimum}
\title{Maximum and minimum values}
\usage{
rray_maximum(x, y)

rray_minimum(x, y)
}
\arguments{
\item{x, y}{A vector, matrix, array or rray.}
}
\value{
The elementwise max/min of \code{x} and \code{y}, with broadcasting.
}
\description{
\code{rray_maximum()} and \code{rray_minimum()} compute the elementwise max / min
between \code{x} and \code{y}.
}
\examples{
# Elementwise maximum
rray_maximum(c(1, 2, 3), c(3, 2, 1))

# Elementwise minimum
rray_minimum(c(1, 2, 3), c(3, 2, 1))

# With broadcasting
x <- matrix(1:3)
rray_maximum(x, t(x))

}
