% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full-like.R
\name{rray_full_like}
\alias{rray_full_like}
\alias{rray_ones_like}
\alias{rray_zeros_like}
\title{Create an array like \code{x}}
\usage{
rray_full_like(x, value)

rray_ones_like(x)

rray_zeros_like(x)
}
\arguments{
\item{x}{A vector, matrix, array or rray.}

\item{value}{A value coercible to the same \emph{inner} type as \code{x} that will be
used to fill the result (If \code{x} is an integer matrix, then \code{value} will be
coerced to an integer).}
}
\value{
An object with the same type as \code{x}, but filled with \code{value}.
}
\description{
\itemize{
\item \code{rray_full_like()} creates an array with the same type and size as \code{x}, but
filled with \code{value}.
\item \code{rray_ones_like()} is \code{rray_full_like()} with \code{value = 1}.
\item \code{rray_zeros_like()} is \code{rray_full_like()} with \code{value = 0}.
}
}
\details{
No dimension names will be on the result.
}
\examples{

x <- rray(1:10, c(5, 2))

# Same shape and type as x, but filled with 1
rray_full_like(x, 1L)

# `fill` is coerced to `x` if it can be
rray_full_like(x, FALSE)

# `value = 1`
rray_ones_like(x)

# When logicals are used, it is filled with TRUE
rray_ones_like(c(FALSE, TRUE))

# `value = 0`
rray_zeros_like(x)

}
