/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.syntax.TemplateTriple;
import com.hp.hpl.jena.sparql.syntax.TemplateVisitor;
import com.hp.hpl.jena.sparql.syntax.TripleCollector;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateGroup
extends Template
implements TripleCollector {
    List<Template> templates = new ArrayList<Template>();
    private int calcHashCode = -1;

    public void add(Template templ) {
        this.templates.add(templ);
    }

    @Override
    public void addTriple(Triple t) {
        this.templates.add(new TemplateTriple(t));
    }

    @Override
    public int mark() {
        return this.templates.size();
    }

    @Override
    public void addTriple(int index, Triple t) {
        this.templates.add(index, new TemplateTriple(t));
    }

    @Override
    public void addTriplePath(TriplePath path) {
        throw new ARQException("Triples-only collector");
    }

    @Override
    public void addTriplePath(int index, TriplePath path) {
        throw new ARQException("Triples-only collector");
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public Iterator<Template> templates() {
        return this.templates.iterator();
    }

    @Override
    public void subst(Collection<Triple> acc, Map<Node, Node> bNodeMap, Binding b) {
        for (Template t : this.templates) {
            t.subst(acc, bNodeMap, b);
        }
    }

    @Override
    public int hashCode() {
        int calcHashCode = 177;
        return calcHashCode ^= ((Object)this.getTemplates()).hashCode();
    }

    @Override
    public boolean equalIso(Object temp2, NodeIsomorphismMap labelMap) {
        if (temp2 == null) {
            return false;
        }
        if (!(temp2 instanceof TemplateGroup)) {
            return false;
        }
        TemplateGroup tg2 = (TemplateGroup)temp2;
        if (this.getTemplates().size() != tg2.getTemplates().size()) {
            return false;
        }
        for (int i = 0; i < this.getTemplates().size(); ++i) {
            Template t2;
            Template t1 = this.getTemplates().get(i);
            if (t1.equalIso(t2 = tg2.getTemplates().get(i), labelMap)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(TemplateVisitor visitor) {
        visitor.visit(this);
    }
}

