/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.GraphListener;
import com.hp.hpl.jena.graph.Triple;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphListenerBase
implements GraphListener {
    public void notifyAddTriple(Graph g, Triple t) {
        this.addEvent(t);
    }

    public void notifyAddArray(Graph g, Triple[] triples) {
        for (int i = 0; i < triples.length; ++i) {
            this.addEvent(triples[i]);
        }
    }

    public void notifyAddList(Graph g, List<Triple> triples) {
        this.notifyAddIterator(g, triples.iterator());
    }

    public void notifyAddIterator(Graph g, Iterator<Triple> it) {
        while (it.hasNext()) {
            this.addEvent(it.next());
        }
    }

    public void notifyAddGraph(Graph g, Graph added) {
    }

    public void notifyDeleteTriple(Graph g, Triple t) {
        this.deleteEvent(t);
    }

    public void notifyDeleteList(Graph g, List<Triple> triples) {
        this.notifyDeleteIterator(g, triples.iterator());
    }

    public void notifyDeleteArray(Graph g, Triple[] triples) {
        for (int i = 0; i < triples.length; ++i) {
            this.deleteEvent(triples[i]);
        }
    }

    public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        while (it.hasNext()) {
            this.deleteEvent(it.next());
        }
    }

    public void notifyDeleteGraph(Graph g, Graph removed) {
    }

    protected abstract void addEvent(Triple var1);

    protected abstract void deleteEvent(Triple var1);

    public void notifyEvent(Graph source, Object value) {
        if (value.equals(GraphEvents.startRead)) {
            this.startRead();
        } else if (value.equals(GraphEvents.finishRead)) {
            this.finishRead();
        }
    }

    protected void startRead() {
    }

    protected void finishRead() {
    }
}

