/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.AnonId;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.cache.Getter;
import org.apache.jena.riot.lang.BlankNodeAllocator;

public class BlankNodeAllocatorHash
implements BlankNodeAllocator {
    private static String DigestAlgorithm = "MD5";
    private static int CacheSize = 1000;
    private MessageDigest mDigest;
    private byte[] seedBytes;
    private byte[] counterBytes = new byte[10];
    private Cache<String, Node> cache;
    private long counter = 0L;

    public BlankNodeAllocatorHash() {
        this.reset();
        try {
            this.mDigest = MessageDigest.getInstance(DigestAlgorithm);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new InternalErrorException("failed to create message digest", e2);
        }
        Getter<String, Node> getter = new Getter<String, Node>(){

            @Override
            public Node get(String key) {
                return BlankNodeAllocatorHash.this.alloc(key);
            }
        };
        Cache cache1 = CacheFactory.createCache(CacheSize);
        this.cache = CacheFactory.createCacheWithGetter(cache1, getter);
    }

    @Override
    public void reset() {
        UUID seed = UUID.randomUUID();
        this.seedBytes = new byte[16];
        Bytes.setLong(seed.getMostSignificantBits(), this.seedBytes, 0);
        Bytes.setLong(seed.getLeastSignificantBits(), this.seedBytes, 8);
    }

    @Override
    public Node alloc(String label) {
        return this.alloc(Bytes.string2bytes(label));
    }

    @Override
    public Node create() {
        ++this.counter;
        this.counterBytes[0] = 0;
        this.counterBytes[1] = 0;
        Bytes.setLong(this.counter, this.counterBytes, 2);
        return this.alloc(this.counterBytes);
    }

    private Node alloc(byte[] labelBytes) {
        this.mDigest.update(this.seedBytes);
        this.mDigest.update(labelBytes);
        byte[] bytes = this.mDigest.digest();
        String hexString = Bytes.asHexLC(bytes);
        return NodeFactory.createAnon((AnonId)new AnonId(hexString));
    }
}

