% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regrad.R
\name{regrad}
\alias{regrad}
\title{Dartboard diagram for precision}
\source{
\code{hfdata} is a sample data which does not derive from a real data
}
\usage{
regrad(data, x, y, long = FALSE, title, size, pct1, pct2, col1, col2, col3,
  ...)
}
\arguments{
\item{data}{Data set}

\item{x}{Names of variable}

\item{y}{Value of the variable}

\item{long}{Split whitespaces of the variable names}

\item{title}{Title for the plot}

\item{size}{Size of the point}

\item{pct1}{Percentage first pie proportion}

\item{pct2}{Percentage second pie proportion}

\item{col1}{Colour of the first pie proportion}

\item{col2}{Colour of the second pie proportion}

\item{col3}{Colour of the third pie proportion}

\item{...}{Additional arguments}
}
\description{
Create a dartboard style diagram to visualise precision. The middle point represent complete precision for example
the objectives or plans.  Imagine it's like a dartboard and the center means 100\% precision or it could be completeness/achievement.
The standard division of the proportion to show precision allocated in the diagram is 50\%, 80\% and 100\%.
}
\details{
These parameters should be specified:
\itemize{
 \item \code{x-axis} {1st column: The names of the different institutions}
 \item \code{y-axis} {2nd column: The value to show completeness}
}
}
\note{
The \code{ggplot2} package is required to run this function
}
\examples{
# basic usage
library("rreg")
regrad(data = hfdata)
regrad(data = hfdata, title = "Plot title", long = TRUE)
regrad(hfdata, y= case1, title="Plot title", size=10, col1="blue", col2="green", col3="yellow")

}
