% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrr.R
\name{rrr}
\alias{rrr}
\title{Multivariate reduced-rank linear regression}
\usage{
rrr(Y, X, penaltySVD = c("rank", "ann"),
    ic.type = c("GIC","AIC","BIC","BICP","GCV"),
    df.type = c("exact","naive"), maxrank = min(dim(Y), dim(X)),
    modstr = list(), control = list())
}
\arguments{
\item{Y}{a matrix of response (n by q)}

\item{X}{a matrix of covariate (n by p)}

\item{penaltySVD}{`rank': rank-constrainted estimation; `ann': adaptive
nuclear norm estimation.}

\item{ic.type}{the information criterion to be used; currently supporting
`AIC', `BIC', `BICP', `GCV', and `GIC'.}

\item{df.type}{`exact': the exact degrees of freedoms based on SURE theory;
`naive': the naive degress of freedoms based on counting number of free
parameters}

\item{maxrank}{an integer of maximum desired rank.}

\item{modstr}{a list of model parameters controlling the model fitting}

\item{control}{a list of parameters for controlling the fitting process:
`sv.tol' controls the tolerence of singular values; `qr.tol' controls
the tolerence of QR decomposition for the LS fit}
}
\value{
S3 \code{rrr} object, a list consisting of
\item{call}{original function call}
\item{Y}{input matrix of response}
\item{X}{input matrix of covariate}
\item{A}{right singular matri x of the least square fitted matrix}
\item{Ad}{a vector of squared singular values of the least square
    fitted matrix}
\item{coef.ls}{coefficient estimate from LS}
\item{Spath}{a matrix, each column containing shrinkage factors of the
    singular values of a solution; the first four objects can be
used to recover all reduced-rank solutions}
\item{df.exact}{the exact degrees of freedom}
\item{df.naive}{the naive degrees of freedom}
\item{penaltySVD}{the method of low-rank estimation}
\item{sse}{a vecotr of sum of squard errors}
\item{ic}{a vector of information criterion}
\item{coef}{estimated coefficient matrix}
\item{U}{estimated left singular matrix such that XU/sqrtn is orthogonal}
\item{V}{estimated right singular matrix that is orthogonal}
\item{D}{estimated singular value matrix such that C = UDVt}
\item{rank}{estimated rank}
}
\description{
Produce solution paths of reduced-rank estimators and adaptive nuclear norm
penalized estimators; compute the degrees of freeom of the RRR estimators
and select a solution via certain information criterion.
}
\details{
Model parameters can be specified through argument \code{modstr}.  The
available include
\itemize{
   \item{gamma}: A scalar power parameter of the adaptive weights in
\code{penalty == "ann"}.

   \item{nlambda}: The number of lambda values; no effect if
\code{penalty == "count"}.

   \item{lambda}: A vector of user-specified rank values if
\code{penalty == "count"} or a vector of penalty values if \code{penalty ==
"ann"}.
}

The available elements for argument \code{control} include
\itemize{
   \item{sv.tol}: singular value tolerence.
   \item{qr.tol}: QR decomposition tolerence.
}
}
\examples{
library(rrpack)
p <- 50; q <- 50; n <- 100; nrank <- 3
mydata <- rrr.sim1(n, p, q, nrank, s2n = 1, sigma = NULL,
                   rho_X = 0.5, rho_E = 0.3)
rfit <- with(mydata, rrr(Y, X, maxrank = 10))
summary(rfit)
coef(rfit)
plot(rfit)
}
\references{
Chen, K., Dong, H. and Chan, K.-S. (2013) Reduced rank regression via
adaptive nuclear norm penalization. \emph{Biometrika}, 100, 901--920.
}
