% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_2ggplots.R
\name{add_2plots}
\alias{add_2plots}
\title{Add two plots into a document object}
\usage{
add_2plots(mydoc, plotstring1, plotstring2, width = 3, height = 2.5,
  echo = FALSE, top = 2)
}
\arguments{
\item{mydoc}{A document object}

\item{plotstring1}{An R code string encoding the first plot}

\item{plotstring2}{An R code string encoding the second plot}

\item{width}{plot width in inches}

\item{height}{plot height in inches}

\item{echo}{logical Whether or not show R code}

\item{top}{top plot position in inches}
}
\value{
a document object
}
\description{
Add two plots into a document object
}
\examples{
require(magrittr)
require(officer)
plotstring1="plot(1:10)"
plotstring2="hist(rnorm(100))"
read_pptx() \%>\% add_text(title="Two plots") \%>\% add_2plots(plotstring1,plotstring2) \%>\%
print(target=paste0(tempdir(),"/","demo.pptx"))
}
