% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotMove.R
\name{hotMove}
\alias{hotMove}
\title{hotMove}
\usage{
hotMove(xy = xy, pxr = pxr, shp = FALSE)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} of \emph{SpatialPointsDataFrame}.}

\item{pxr}{Grid resolution. Unit depends on \emph{xy} projection.}

\item{shp}{Logical. Should the function provide polygons? Default is FALSE.}
}
\value{
A list object.
}
\description{
Identifies hotspots of samples using a pixel based approach.
}
\details{
{The function builds a matrix for a given resolution and a 
spatial extent derived from a set of samples (\emph{xy}). First, these 
samples are converted into unique pixel coordinates. Then, the 
spatial connectivity of these pixels is evaluated using a 8-neighboor 
connected component labelling algorithm. The function returns a vector 
with the region ID per sample (\emph{$indices}). If \emph{shp} is TRUE the 
function also returns a shapefile for each region defined by the 
convex hull of the samples within them (\emph{$polygons}).}
}
\examples{
{

require(rgdal)
require(raster)
require(sp)

# reference data
file <- system.file('extdata', 'latLon_example.shp', package="rsMove")
moveData <- shapefile(file)

# extract regions
hm <- hotMove(xy=moveData, pxr=0.1, shp=TRUE)

# plot shapefile (color by region)
plot(hm$polygons, col=hm$indices)

# add new information to original shapefile
moveData@data <- cbind(moveData@data, hm$indices)

}
}
\seealso{
\code{\link{sampleMove}} \code{\link{hotMoveStats}}
}
