% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complement.R
\name{complement}
\alias{complement}
\title{Determine the Assessment Samples}
\usage{
complement(x, ...)
}
\arguments{
\item{x}{An \code{rsplit} object}

\item{...}{Not currently used}
}
\value{
A integer vector.
}
\description{
Given an \code{rsplit} object, \code{complement} will determine which
of the data rows are contained in the assessment set. To save space,
many of the \code{rset} objects will not contain indices for the
assessment split.
}
\examples{
set.seed(28432)
fold_rs <- vfold_cv(mtcars)
head(fold_rs$splits[[1]]$in_id)
fold_rs$splits[[1]]$out_id
complement(fold_rs$splits[[1]])
}
\seealso{
\code{\link[=populate]{populate()}}
}
