% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalaPackage.R
\name{scalaPackage}
\alias{scalaPackage}
\title{Embed a Scala Bridge in a Package}
\usage{
scalaPackage(packages = character(), assign.callback = function(s) { },
  assign.name = "s", JARs = character(), mode = "", ...)
}
\arguments{
\item{packages}{Character vector of package names whose embedded JAR files
are to be added to the classpath.}

\item{assign.callback}{A function taking a Scala bridge as its only argument.
This function is called immediately after the bridge is connected, which
does not happen until the bridge is actually used and may be long after
this function finishes. This is where setup code goes, like \emph{global}
imports, objects, classes, methods, etc.  For example, it might equal
\code{function(s) { s + 'import scala.util.Random' }}.  \strong{Note} the
use of the execution operator \code{+} instead of the evaluation operator
\code{*}.}

\item{assign.name}{The name of the (promise of the) bridge to be assigned in
the environment given by the \code{assign.env} argument.}

\item{JARs}{Character vector whose elements are individual JAR files to be
added to the runtime classpath.}

\item{mode}{A string.  If the package is to have its own bridge, this should
be \code{""}.  If the package is to use the bridge of another package
(e.g., package "foo"), then this should be the fully qualified variable of
that package (e.g., \code{"foo:::s"}).}

\item{...}{When using \code{mode=""}, other arguments passed to the function
\code{\link{scala}}.}
}
\value{
Returns \code{NULL}, invisibly.
}
\description{
This function should be called in the \code{\link{.onLoad}} function of a
depending package.
}
\details{
The function makes an rscala bridge available to the functions of the
package. Package developers should call this function in the package's
\code{\link{.onLoad}} function. The \code{\link{scalaPackageUnload}} function
should be called in the package's \code{\link{.onUnload}} function.
}
\examples{
\dontrun{

.onLoad <- function(libname, pkgname) {
  scalaPackage(c(pkgname, "commonsMath"), function(s) s + "
    import org.apache.commons.math3._
  ")
}
}

}
\seealso{
\code{\link{scalaPackageUnload}}, \code{\link{scala}}
}
