% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalaHeapMaximum.R
\name{scalaHeapMaximum}
\alias{scalaHeapMaximum}
\title{Globally Set Scala's Maximum Heap Size}
\usage{
scalaHeapMaximum(heap.maximum = NULL)
}
\arguments{
\item{heap.maximum}{String indicating the JVM heap maximum, e.g., "8G".
Without this being set in either \code{\link{scala}} or
\code{\link{scalaHeapMaximum}}, the heap maximum will be 85\% of the
physical RAM.  The value from \code{\link{scalaHeapMaximum}} supersedes
that from \code{\link{scala}}.}
}
\value{
Returns \code{NULL}, invisibly.
}
\description{
This function sets the maximum heap size for new instances of rscala bridges
created by the function \code{\link{scala}}.  The value set here overrides
the argument of the same name of the function \code{\link{scala}}.  Set the
argument to \code{NULL} to disable this global option.  The function is helpful
for users of packages that depend on rscala.
}
\examples{
\dontrun{
scalaHeapMaximum("1G")
}
}
\seealso{
\code{\link{scala}}
}
