% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalaConfig.R
\name{scalaConfig}
\alias{scalaConfig}
\title{Configure Scala and Java}
\usage{
scalaConfig(verbose = TRUE, reconfig = FALSE,
  download = character(0), require.sbt = FALSE)
}
\arguments{
\item{verbose}{Should details of the search for Scala and Java be provided?
Or, if a Scala bridge is provided instead of a logical, the function
returns a list of details associated with the supplied bridge.}

\item{reconfig}{If \code{TRUE}, the script \code{~/.rscala/config.R} is
rewritten based on a new search for Scala and Java.  If \code{FALSE}, the
previous configuration is sourced from the script
\code{~/.rscala/config.R}.  If \code{"live"}, a new search is performed,
but the results do not overwrite the previous configuration script.
Finally, the value set here is superceded by the value of the environment
variable \code{RSCALA_RECONFIG}, if it exists.}

\item{download}{A character vector which may be length-zero or whose elements
are any combination of \code{"java"}, \code{"scala"}, or \code{"sbt"}. Or,
\code{TRUE} denotes all three.  The indicated software will be installed in
"~/.rscala".}

\item{require.sbt}{Should SBT be required, downloading and installing it in
'~/.rscala/sbt' if necessary?}
}
\value{
Returns a list of details of the Scala and Java binaries.
}
\description{
This function installs Scala and/or Java in the user's \code{~/.rscala}
directory.
}
\examples{
\donttest{
scalaConfig()
}

}
\references{
{David B. Dahl (2019). "Integration of R and Scala Using rscala."
  Journal of Statistical Software, in editing. https://www.jstatsoft.org}
}
