% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{^.rscalaBridge}
\alias{^.rscalaBridge}
\title{Evaluation Operator Returning a Reference and Transcompile Operator}
\usage{
\method{^}{rscalaBridge}(bridge, snippet)
}
\arguments{
\item{bridge}{An rscala bridge.}

\item{snippet}{String providing a Scala code snippet.}
}
\value{
Returns an rscala reference.
}
\description{
This operator is equivalent to \code{\link{*.rscalaBridge}}, except the
return value is always an rscala reference. This operator also allows (a
small subset of) R code to be transcompiled to Scala code and produces an
rscala reference to an anonymous Scala function.
}
\examples{
\donttest{
s <- scala()
x <- s ^ 'new scala.util.Random()'  # These two lines ...
x <- s $ .new_scala.util.Random()   # ... are equivalent
s(rng=x) * 'rng.nextDouble()'
f <- s ^ function(x=scalaType('Double')) { pi - x }
f$apply(3.14)
s(n=10L, mapper=s ^ function(x=scalaType("Int")) { 2 * x }) * "Array.tabulate(n)(mapper)"
logStdNormalDensity <- s ^ function(x=scalaType("Double"), mean=0.0, sd=1.0) {
  variance <- sd^2
  -0.5*log(2*pi*variance) - 0.5/variance * (x-mean)^2
}
identical(logStdNormalDensity$apply(1.0), dnorm(1.0, log=TRUE))
close(s)
}

}
\seealso{
\code{\link{*.rscalaBridge}}, \code{\link{+.rscalaBridge}},
  \code{\link{scala}}
}
