% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_article_references.R
\name{get_article_references}
\alias{get_article_references}
\title{Scrape bibliographic references from a single article hosted on Scielo}
\usage{
get_article_references(x)
}
\arguments{
\item{x}{a character vector with the link or the id of the article hosted on Scielo
to be scrapped.}
}
\value{
The function a \code{tibble} with the following variables:

\itemize{
  \item references: an article's bibliographic reference (\code{character}).
  \item doi: article's Digital Object Identifier (DOI).
}
}
\description{
\code{get_article_references()} scrapes a list of bibliographic references
cited by an article hosted on Scielo.
}
\note{
Sometimes, the Scielo website is offline for maintaince,
in which cases this function will not work (i.e., users will get HTML status
different from the usual 200 OK).
}
\examples{
\donttest{
refs <- get_article_references(x = "http://www.scielo.br/scielo.php?
script=sci_arttext&pid=S1981-38212016000200201&lng=en&nrm=iso&tlng=en")
}
}
