% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeManifest.R
\name{writeManifest}
\alias{writeManifest}
\title{Create a \code{manifest.json}}
\usage{
writeManifest(
  appDir = getwd(),
  appFiles = NULL,
  appFileManifest = NULL,
  appPrimaryDoc = NULL,
  appMode = NULL,
  contentCategory = NULL,
  python = NULL,
  forceGeneratePythonEnvironment = FALSE,
  quarto = NA,
  image = NULL,
  envManagement = NULL,
  envManagementR = NULL,
  envManagementPy = NULL,
  verbose = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{appDir}{A directory containing an application (e.g. a Shiny app
or plumber API). Defaults to the current directory.}

\item{appFiles, appFileManifest}{Use \code{appFiles} to specify a
character vector of files to bundle in the app or \code{appFileManifest}
to provide a path to a file containing a list of such files. If neither
are supplied, will bundle all files in \code{appDir}, apart from standard
exclusions and files listed in a \code{.rscignore} file. See
\code{\link[=listDeploymentFiles]{listDeploymentFiles()}} for more details.}

\item{appPrimaryDoc}{If the application contains more than one document, this
parameter indicates the primary one, as a path relative to \code{appDir}. Can be
\code{NULL}, in which case the primary document is inferred from the contents
being deployed.}

\item{appMode}{Optional; the type of content being deployed.
Provide this option when the inferred type of content is incorrect. This
can happen, for example, when static HTML content includes a downloadable
Shiny application \code{app.R}. Accepted values include \code{"shiny"}, \code{"api"},
\code{"rmd-static"}, \code{"rmd-shiny"}, \code{"quarto-static"}, \code{"quarto-shiny"}, and
\code{"static"}. The Posit Connect API Reference contains a full set of
available values. Not all servers support all types of content.}

\item{contentCategory}{Set this to \code{"site"} if you'd deploy with
\code{\link[=deploySite]{deploySite()}}; otherwise leave as is.}

\item{python}{Full path to a python binary for use by \code{reticulate}.
Required if \code{reticulate} is a dependency of the app being deployed.
If python = NULL, and RETICULATE_PYTHON or RETICULATE_PYTHON_FALLBACK is
set in the environment, its value will be used. The specified python binary
will be invoked to determine its version and to list the python packages
installed in the environment.}

\item{forceGeneratePythonEnvironment}{Optional. If an existing
\code{requirements.txt} file is found, it will be overwritten when this argument
is \code{TRUE}.}

\item{quarto}{Should the deployed content be built by quarto?
(\code{TRUE}, \code{FALSE}, or \code{NA}). The default, \code{NA}, will use quarto if
there are \code{.qmd} files in the bundle, or if there is a
\verb{_quarto.yml} and \code{.Rmd} files.

(This option is ignored and quarto will always be used if the
\code{metadata} contains \code{quarto_version} and \code{quarto_engines} fields.)}

\item{image}{Optional. The name of the image to use when building and
executing this content. If none is provided, Posit Connect will
attempt to choose an image based on the content requirements. You can
override the default by setting the environment variable \code{RSCONNECT_IMAGE}.}

\item{envManagement}{Optional. Should Posit Connect install R and Python
packages for this content? (\code{TRUE}, \code{FALSE}, or \code{NULL}).
The default, \code{NULL}, will not write any values to the bundle manifest,
and Connect will fall back to the application default environment
management strategy, or the server default if no application default
is defined.

(This option is a shorthand flag which overwrites the values of both
\code{envManagementR} and \code{envManagementPy}.)}

\item{envManagementR}{Optional. Should Posit Connect install R packages
for this content? (\code{TRUE}, \code{FALSE}, or \code{NULL}). The default, \code{NULL}, will
not write any values to the bundle manifest, and Connect will fall back to
the application default R environment management strategy, or the server
default if no application default is defined.

(This option is ignored when \code{envManagement} is non-\code{NULL}.)}

\item{envManagementPy}{Optional. Should Posit Connect install Python packages
for this content? (\code{TRUE}, \code{FALSE}, or \code{NULL}). The default, \code{NULL}, will
not write any values to the bundle manifest, and Connect will fall back to
the application default Python environment management strategy, or the
server default if no application default is defined.

(This option is ignored when \code{envManagement} is non-\code{NULL}.)}

\item{verbose}{If \code{TRUE}, prints detailed progress messages.}

\item{quiet}{If \code{FALSE}, prints progress messages.}
}
\description{
Use \code{writeManifest()} to generate a \code{manifest.json}. Among other things,
you can commit this file to git to activate
\href{https://docs.posit.co/connect/user/git-backed/}{Git-Backed content}
for Posit Connect.

\code{manifest.json} contains a list of all files in the app along with their
dependencies, so you will need to re-run \code{writeManifest()} when either of
these change.

Supported servers: All servers
}
