% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SDMXDataStructure.R,
%   R/SDMXDataStructure-methods.R
\docType{class}
\name{SDMXDataStructure}
\alias{SDMXDataStructure}
\alias{SDMXDataStructure-class}
\alias{SDMXDataStructure,SDMXDataStructure-method}
\title{Class "SDMXDataStructure"}
\usage{
SDMXDataStructure(xmlObj, namespaces)
}
\arguments{
\item{xmlObj}{object of class "XMLInternalDocument derived from XML package}

\item{namespaces}{object of class "data.frame" given the list of namespace URIs}
}
\value{
an object of class "SDMXDataStructure"
}
\description{
A basic class to handle a SDMX DataStructure (or KeyFamily)
}
\section{Slots}{

\describe{
\item{\code{id}}{Object of class "character" giving the ID (required)}

\item{\code{agencyID}}{Object of class "character" giving the AgencyID}

\item{\code{version}}{Object of class "character" giving the version}

\item{\code{uri}}{Object of class "character" giving the uri}

\item{\code{urn}}{Object of class "character" giving the urn}

\item{\code{isExternalReference}}{Object of class "logical" indicating if the datastructure / keyfamily is an external reference}

\item{\code{isFinal}}{Object of class "logical" indicating if the datastructure / keyfamily is final}

\item{\code{validFrom}}{Object of class "character" indicating the start validity period}

\item{\code{validTo}}{Object of class "character" indicating the end validity period}

\item{\code{Name}}{Object of class "list" giving the codelist (by language) - required}

\item{\code{Description}}{Object of class "list" giving the codelist description (by language)}

\item{\code{Components}}{Object of class "SDMXComponents" (see \link{SDMXComponents})}
}}

\section{Warning}{

This class is not useful in itself, but all SDMX non-abstract classes will 
encapsulate it as slot, when parsing an SDMX-ML document (Concepts, or 
DataStructureDefinition)
}

\seealso{
\link{readSDMX}
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
