% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.simsum.R
\name{summary.simsum}
\alias{summary.simsum}
\title{Summarising simsum objects}
\usage{
\method{summary}{simsum}(object, ci_level = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{simsum}.}

\item{ci_level}{Significance level for confidence intervals based on Monte Carlo standard errors. Ignored if a \code{simsum} object with \code{mcse = FALSE} is passed.}

\item{...}{Ignored.}
}
\value{
An object of class \code{summary.simsum}.
}
\description{
The \code{summary()} method for objects of class \code{simsum} returns confidence intervals for performance measures based on Monte Carlo standard errors.
}
\details{
summary.simsum
}
\note{
Confidence intervals are constructed using quantiles from a normal distribution with the specified \code{ci_level} confidence level, and are therefore symmetric by definition.
}
\examples{
data("MIsim")
object <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se",
methodvar = "method", mcse = TRUE)
xs <- summary(object)
xs
}
\seealso{
\code{\link[=simsum]{simsum()}}, \code{\link[=print.summary.simsum]{print.summary.simsum()}}
}
