context("lolly")
library(ggplot2)

test_that("lolly checks arguments properly", {
  data("MIsim", package = "rsimsum")
  s1 <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method")
  expect_error(lolly(obj = MIsim))
  expect_error(lolly(obj = s1))
  expect_error(lolly(obj = s1, sstat = "BIAS"))
  expect_error(lolly(obj = s1, sstat = "nsim"))
  expect_error(lolly(obj = s1, sstat = "bias", level = 101))
  data("frailty", package = "rsimsum")
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist")
  expect_error(lolly(obj = sm))
  expect_error(lolly(obj = sm, sstat = "BIAS"))
  expect_warning(expect_error(lolly(obj = sm, sstat = "nsim")))
  expect_error(lolly(obj = sm, sstat = "bias", level = 101))
})

test_that("lolly returns a ggplot object", {
  data("MIsim", package = "rsimsum")
  s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method")
  data("frailty", package = "rsimsum")
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model")
  expect_s3_class(lolly(s, sstat = "bias"), class = c("gg", "ggplot"))
  expect_s3_class(lolly(sm, sstat = "bias", par = "trt"), class = c("gg", "ggplot"))
})

test_that("lolly does not plot CI when simsum in called with mcse = FALSE", {
  data("MIsim", package = "rsimsum")
  s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method", mcse = FALSE)
  lolly(s, sstat = "bias")
  data("frailty", package = "rsimsum")
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", mcse = FALSE)
  lolly(sm, sstat = "bias", par = "trt")
})

test_that("lolly works with 'by' factors", {
  data("relhaz", package = "rsimsum")
  s <- simsum(data = relhaz, estvarname = "theta", true = -0.5, se = "se", methodvar = "model", by = c("n", "baseline"))
  expect_warning(lolly(s, sstat = "bias"))
  expect_error(lolly(s, sstat = "bias", by = "random-name"))
  expect_s3_class(lolly(s, sstat = "bias", by = c("n", "baseline")), class = c("gg", "ggplot"))
  data("frailty", package = "rsimsum")
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist")
  expect_warning(lolly(sm, sstat = "bias", par = "trt"))
  expect_error(lolly(sm, sstat = "bias", par = "trt", by = "random-name"))
  expect_s3_class(lolly(sm, sstat = "bias", par = "trt", by = "fv_dist"), class = c("gg", "ggplot"))
})

test_that("lolly works when changing graphical parameters", {
  data("MIsim", package = "rsimsum")
  s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method")
  lolly(s, sstat = "bias", gpars = list(target.shape = 1))
  lolly(s, sstat = "bias", gpars = list(target.colour = 2))
  lolly(s, sstat = "bias", gpars = list(segment.shape = 3))
  lolly(s, sstat = "bias", gpars = list(segment.colour = 4))
  lolly(s, sstat = "bias", gpars = list(low.end = 5))
  lolly(s, sstat = "bias", gpars = list(upp.end = 6))
  data("frailty", package = "rsimsum")
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model")
  lolly(sm, sstat = "bias", par = "trt", gpars = list(target.shape = 1))
  lolly(sm, sstat = "bias", par = "trt", gpars = list(target.colour = 2))
  lolly(sm, sstat = "bias", par = "trt", gpars = list(segment.shape = 3))
  lolly(sm, sstat = "bias", par = "trt", gpars = list(segment.colour = 4))
  lolly(sm, sstat = "bias", par = "trt", gpars = list(low.end = 5))
  lolly(sm, sstat = "bias", par = "trt", gpars = list(upp.end = 6))
})

test_that("lolly with all 'sstat' options, with and without 'target'", {
  data("MIsim", package = "rsimsum")
  s <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se", methodvar = "method")
  lolly(s, sstat = "nsim", target = 1000)
  lolly(s, sstat = "thetamean")
  lolly(s, sstat = "thetamean", target = 0.50)
  lolly(s, sstat = "thetamedian")
  lolly(s, sstat = "thetamedian", target = 0.50)
  lolly(s, sstat = "se2mean")
  lolly(s, sstat = "se2mean", target = 0)
  lolly(s, sstat = "se2median")
  lolly(s, sstat = "se2median", target = 0)
  lolly(s, sstat = "bias")
  lolly(s, sstat = "bias", target = 0)
  lolly(s, sstat = "empse")
  lolly(s, sstat = "empse", target = 0)
  lolly(s, sstat = "mse")
  lolly(s, sstat = "mse", target = 0)
  lolly(s, sstat = "relprec")
  lolly(s, sstat = "relprec", target = 1)
  lolly(s, sstat = "modelse")
  lolly(s, sstat = "modelse", target = 0)
  lolly(s, sstat = "relerror")
  lolly(s, sstat = "relerror", target = 0)
  lolly(s, sstat = "cover")
  lolly(s, sstat = "cover", target = 0.95)
  lolly(s, sstat = "bccover")
  lolly(s, sstat = "bccover", target = 0.95)
  lolly(s, sstat = "power")
  lolly(s, sstat = "power", target = 0.95)
  data("frailty", package = "rsimsum")
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "nsim", target = 1000)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "thetamean")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "thetamean", target = -0.50)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "thetamedian")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "thetamedian", target = -0.50)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "se2mean")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "se2mean", target = 0)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "se2median")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "se2median", target = 0)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "bias")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "bias", target = 0)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "empse")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "empse", target = 0)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "mse")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "mse", target = 0)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "relprec")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "relprec", target = 1)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "modelse")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "modelse", target = 0)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "relerror")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "relerror", target = 0)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "cover")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "cover", target = 0.95)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "bccover")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "bccover", target = 0.95)
  lolly(sm, par = "trt", by = "fv_dist", sstat = "power")
  lolly(sm, par = "trt", by = "fv_dist", sstat = "power", target = 0.95)
})

test_that("lolly works for multisimsum object even without specifying par", {
  data("frailty", package = "rsimsum")
  sm <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist")
  lolly(sm, by = "fv_dist", sstat = "bias")
})
