% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epochs.R
\name{segmentation}
\alias{segmentation}
\title{Split signals into consecutive, overlapping segments.}
\usage{
segmentation(
  signals,
  sRates,
  segments_size = 10,
  step = 1,
  padding = 0,
  resample = max(sRates),
  return_index = FALSE
)
}
\arguments{
\item{signals}{A list of numeric vectors containing signals, or a single vector containing one signal.}

\item{sRates}{A vector or list of integer values of the signals sample rates.}

\item{segments_size}{The size of segments, in seconds.}

\item{step}{The step between segments, in seconds.}

\item{padding}{umber of previous and next epochs to pad the current epoch with. Defaults to 0.}

\item{resample}{The sample rate to resample all signals. Defaults to to the max of the provided sample rates.}

\item{return_index}{If TRUE, the index of segments is returned instead of the segments.}
}
\value{
A matrix of segments.
}
\description{
Split signals into consecutive, overlapping segments.
}
\examples{
computed_segments = segmentation(
  signals = list(c(sin(1:1000)),c(cos(1:1000))),
  sRates = c(1, 1),
  segments_size = 5,
  resample = 1)
dim(computed_segments)
plot(computed_segments[1,,1], type = "l")
plot(computed_segments[2,,1], type = "l")
}
\references{
Choi SH, Yoon H, Kim HS, et al. Real-time apnea-hypopnea event detection during sleep by convolutional neural networks. Computers in Biology and Medicine. 2018;100:123-131.
}
