% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_aov.R, R/stan_lm.R, R/stan_lm.fit.R
\name{stan_aov}
\alias{stan_aov}
\alias{stan_lm}
\alias{stan_lm.fit}
\alias{stan_lm.wfit}
\title{Bayesian regularized linear models via Stan}
\usage{
stan_aov(formula, data, projections = FALSE, contrasts = NULL, ...,
  prior = R2(stop("'location' must be specified")), prior_PD = FALSE,
  algorithm = c("sampling", "meanfield", "fullrank"), adapt_delta = NULL)

stan_lm(formula, data, subset, weights, na.action, model = TRUE, x = FALSE,
  y = FALSE, singular.ok = TRUE, contrasts = NULL, offset, ...,
  prior = R2(stop("'location' must be specified")), prior_intercept = NULL,
  prior_PD = FALSE, algorithm = c("sampling", "meanfield", "fullrank"),
  adapt_delta = NULL)

stan_lm.wfit(x, y, w, offset = NULL, singular.ok = TRUE, ...,
  prior = R2(stop("'location' must be specified")), prior_intercept = NULL,
  prior_PD = FALSE, algorithm = c("sampling", "meanfield", "fullrank"),
  adapt_delta = NULL)

stan_lm.fit(x, y, offset = NULL, singular.ok = TRUE, ...,
  prior = R2(stop("'location' must be specified")), prior_intercept = NULL,
  prior_PD = FALSE, algorithm = c("sampling", "meanfield", "fullrank"),
  adapt_delta = NULL)
}
\arguments{
\item{formula, data, subset}{Same as \code{\link[stats]{lm}}, 
but \emph{we strongly advise against omitting the \code{data}
argument}. Unless \code{data} is specified (and is a data frame) many
post-estimation functions (including \code{update}, \code{loo},
\code{kfold}) are not guaranteed to work properly.}

\item{projections}{For \code{stan_aov}, a logical scalar (defaulting to
\code{FALSE}) indicating whether \code{\link[stats]{proj}} should be called
on the fit.}

\item{...}{Further arguments passed to the function in the \pkg{rstan} 
package (\code{\link[rstan]{sampling}}, \code{\link[rstan]{vb}}, or 
\code{\link[rstan]{optimizing}}), corresponding to the estimation method 
named by \code{algorithm}. For example, if \code{algorithm} is
\code{"sampling"} it is possibly to specify \code{iter}, \code{chains},
\code{cores}, \code{refresh}, etc.}

\item{prior}{Must be a call to \code{\link{R2}} with its 
\code{location} argument specified or \code{NULL}, which would
indicate a standard uniform prior for the \eqn{R^2}.}

\item{prior_PD}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to draw from the prior predictive distribution instead of
conditioning on the outcome.}

\item{algorithm}{A string (possibly abbreviated) indicating the 
estimation approach to use. Can be \code{"sampling"} for MCMC (the
default), \code{"optimizing"} for optimization, \code{"meanfield"} for
variational inference with independent normal distributions, or
\code{"fullrank"} for variational inference with a multivariate normal
distribution. See \code{\link{rstanarm-package}} for more details on the
estimation algorithms. NOTE: not all fitting functions support all four
algorithms.}

\item{adapt_delta}{Only relevant if \code{algorithm="sampling"}. See 
\code{\link{adapt_delta}} for details.}

\item{na.action, singular.ok, contrasts}{Same as \code{\link[stats]{lm}}, but 
rarely specified.}

\item{model, offset, weights}{Same as \code{\link[stats]{lm}}, but
rarely specified.}

\item{x, y}{In \code{stan_lm, stan_aov}, logical scalars indicating whether to
return the design matrix and response vector. In \code{stan_lm.fit or stan_lm.wfit},
a design matrix and response vector.}

\item{prior_intercept}{Either \code{NULL} (the default) or a call to
\code{\link{normal}}. If a \code{\link{normal}} prior is specified
without a \code{scale}, then the standard deviation is taken to be
the marginal standard deviation of the outcome divided by the square
root of the sample size, which is legitimate because the marginal
standard deviation of the outcome is a primitive parameter being
estimated.}

\item{w}{Same as in \code{\link[stats]{lm.wfit}} but rarely specified.}
}
\value{
A \link[=stanreg-objects]{stanreg} object is returned 
for \code{stan_lm, stan_aov}.

A \link[=stanfit-class]{stanfit} object (or a slightly modified 
  stanfit object) is returned if \code{stan_lm.fit or stan_lm.wfit} is called directly.
}
\description{
Bayesian inference for linear modeling with regularizing priors on the 
model parameters that are driven by prior beliefs about \eqn{R^2}, the 
proportion of variance in the outcome attributable to the predictors. See 
\code{\link{priors}} for an explanation of this critical point. 
\code{\link{stan_glm}} with \code{family="gaussian"} also estimates a 
linear model with normally-distributed errors and allows for various other 
priors on the coefficients.
}
\details{
The \code{stan_lm} function is similar in syntax to the 
  \code{\link[stats]{lm}} function but rather than choosing the parameters to
  minimize the sum of squared residuals, samples from the posterior 
  distribution are drawn using MCMC (if \code{algorithm} is
  \code{"sampling"}). The \code{stan_lm} function has a formula-based
  interface and would usually be called by users but the \code{stan_lm.fit}
  and \code{stan_lm.wfit} functions might be called by other functions that
  parse the data themselves and are analagous to \code{\link[stats]{lm.fit}}
  and \code{\link[stats]{lm.wfit}} respectively.
     
  In addition to estimating \code{sigma} --- the standard deviation of the
  normally-distributed errors --- this model estimates a positive parameter
  called \code{log-fit_ratio}. If it is positive, the marginal posterior 
  variance of the outcome will exceed the sample variance of the outcome
  by a multiplicative factor equal to the square of \code{fit_ratio}.
  Conversely if \code{log-fit_ratio} is negative, then the model underfits.
  Given the regularizing nature of the priors, a slight underfit is good.
  
  Finally, the posterior predictive distribution is generated with the
  predictors fixed at their sample means. This quantity is useful for
  checking convergence because it is reasonably normally distributed
  and a function of all the parameters in the model.
  
  The \code{stan_aov} function is similar to \code{\link[stats]{aov}} and
  has a somewhat customized \code{\link{print}} method but basically just 
  calls \code{stan_lm} with dummy variables to do a Bayesian analysis of
  variance.
}
\examples{
\donttest{
op <- options(contrasts = c("contr.helmert", "contr.poly"))
stan_aov(yield ~ block + N*P*K, data = npk,
         prior = R2(0.5), seed = 12345) 
options(op)
}
            
(fit <- stan_lm(mpg ~ wt + qsec + am, data = mtcars, prior = R2(0.75), 
                # the next line is only to make the example go fast enough
                chains = 1, iter = 500, seed = 12345))
plot(fit, prob = 0.8)
plot(fit, "hist", pars = c("wt", "am", "qsec", "sigma"), 
     transformations = list(sigma = "log"))

}
\references{
Lewandowski, D., Kurowicka D., and Joe, H. (2009). Generating random
correlation matrices based on vines and extended onion method. 
\emph{Journal of Multivariate Analysis}. \strong{100}(9), 1989--2001.
}
\seealso{
The vignettes for \code{stan_lm} and \code{stan_aov}, which have more
thorough descriptions and examples.

Also see \code{\link{stan_glm}}, which --- if \code{family =
gaussian(link="identity")} --- also estimates a linear model with
normally-distributed errors but specifies different priors.
}

