% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.stanreg}
\alias{plot.stanreg}
\title{Plot method for stanreg objects}
\usage{
\method{plot}{stanreg}(x, plotfun = NULL, pars = NULL, regex_pars = NULL,
  ...)
}
\arguments{
\item{x}{A fitted model object returned by one of the
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{plotfun}{A character string naming the plotting function to apply to 
the stanreg object. See \code{\link{plots}} for the names and descriptions.
Also see the Examples section below. \code{plotfun} can be either the full 
name of the plotting function (e.g. \code{"stan_hist"}) or can be 
abbreviated to the part of the name following the underscore (e.g. 
\code{"hist"}). The default plot shows intervals and point estimates for 
the coefficients. Note: \code{plotfun} should not be specified for models
fit using \code{algorithm="optimizing"} as there is currently only one
plotting function for these models.}

\item{pars}{An optional character vector of parameter names.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}

\item{...}{Additional arguments to pass to \code{plotfun} (see
\code{\link{plots}}) or, for models fit using
\code{algorithm="optimizing"}, \code{\link[arm]{coefplot}}.}
}
\value{
In most cases, a ggplot object (or several) that can be further 
  customized using the \pkg{ggplot2} package. The exception is for models fit
  using \code{"optimizing"} as the estimation algorithm, in which case a plot
  is produced but nothing is returned.
}
\description{
For models fit using MCMC or one of the variational approximations, there are
a variety of plots that can be generated. For models fit using optimization,
the regression coefficients and standard errors are passed to
\code{\link[arm]{coefplot}} (\pkg{arm}).
}
\examples{
# Use rstanarm example model
fit <- example_model

# Intervals and point estimates
plot(fit) + 
ggplot2::ggtitle("Posterior medians \\n with 80\% and 95\% credible intervals")
plot(fit, pars = "size", regex_pars = "period", 
     ci_level = 0.95, outer_level = 1, show_density = TRUE)

# Traceplot
# note: rstanarm doesn't store the warmup draws by default 
(trace <- plot(fit, "trace", pars = "(Intercept)"))
trace + ggplot2::scale_color_discrete()
trace + ggplot2::scale_color_manual(values = c("maroon", "skyblue2"))

# Distributions 
plot_title <- ggplot2::ggtitle("Posterior Distributions")
plot(fit, "hist", fill = "skyblue", regex_pars = "period") + plot_title
plot(fit, "dens", pars = "(Intercept)", regex_pars = "period", 
     separate_chains = TRUE, alpha = 1/3) + plot_title

# Scatterplot
plot(fit, plotfun = "scat", pars = paste0("period", 2:3))
plot(fit, plotfun = "scat", pars = c("(Intercept)", "size"), 
     color = "black", size = 5, alpha = 0.2)

# Some diagnostics
plot(fit, "rhat")
plot(fit, "ess")

# Using regex_pars
plot(fit, regex_pars = "period")
plot(fit, regex_pars = "herd:1")
plot(fit, regex_pars = "herd:1\\\\]")
plot(fit, regex_pars = "herd:[279]")
plot(fit, regex_pars = "herd:[279]|period2")
plot(fit, regex_pars = c("herd:[279]", "period2"))

# For graphical posterior predictive checks see 
# help("pp_check", package = "rstanarm")

}
\seealso{
\code{\link{plots}} for details on the individual plotting
  functions.
}

