% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stansim_simulation.R
\name{stansim_simulation}
\alias{stansim_simulation}
\title{Construct an S3 object of type stansim_simulation}
\usage{
stansim_simulation(sim_name, stansim_uni_list, start_time, end_time, raw_call,
  seed)
}
\arguments{
\item{sim_name}{The name to be given to the simulation represented by the
\code{stansim_simulation} object.}

\item{stansim_uni_list}{A list of objects with S3 class \code{stan_sim_uni}.
This is an unexported class used to store the outcomes of individual
simulation runs internal to the \code{fit_models()} function.}

\item{start_time}{System time when \code{fit_models()} was called.}

\item{end_time}{System time when the results from \code{fit_models()} were
returned.}

\item{raw_call}{The values of all arguments provided to \code{fit_models()} when
first ran. This is used for any refitting of datasets using the
\code{refit()} method.}

\item{seed}{The global seed for the \code{fit_models()} call.}
}
\value{
An S3 object of class \code{stansim_simulation} recording relevant
  simulation data.
}
\description{
A constructor function for creating S3 objects of class
  \code{stansim_simulation}. \code{stansim_simulation} objects are the basic
  unit of output from calls to the \code{fit_models()} function and collects the
  specified data for all stan models fitted.
}
