% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_error.R
\name{predictive_error}
\alias{predictive_error}
\alias{predictive_error.default}
\title{Generic function for predictive errors}
\usage{
predictive_error(object, ...)

\method{predictive_error}{default}(object, y, ...)
}
\arguments{
\item{object}{The object to use.}

\item{...}{Arguments passed to methods.}

\item{y}{For the default method, a vector of \eqn{y} values the same length
as the number of columns in the matrix used as \code{object}.}
}
\value{
\code{predictive_error} methods should return a \eqn{D} by \eqn{N}
  matrix, where \eqn{D} is the number of draws from the posterior predictive
  distribution and \eqn{N} is the number of data points being predicted per
  draw.

  The default method just takes \code{object} to be a matrix and \code{y}
  to be a vector.
}
\description{
Generic function for computing predictive errors \eqn{y - y^{rep}}{y - yrep}
(in-sample, for observed \eqn{y}) or \eqn{y - \tilde{y}}{y - ytilde}
(out-of-sample, for new or held-out \eqn{y}). See
\code{predictive_error.stanreg} in the \pkg{rstanarm} package for an example.
}
\examples{
# default method
y <- rnorm(10)
ypred <- matrix(rnorm(500), 50, 10)
predictive_error(ypred, y)

# Also see help("predictive_error", package = "rstanarm")

}
\seealso{
The \pkg{rstanarm} package for example methods
  (\url{https://CRAN.R-project.org/package=rstanarm}).

The guidelines for developers of R packages interfacing with Stan, a
  copy of which can be found in the package vignettes. See
  \code{browseVignettes("rstantools")} or \code{vignette(package =
  "rstantools")}.
}

