% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_interval.R
\name{predictive_interval}
\alias{predictive_interval}
\alias{predictive_interval.default}
\title{Generic function for predictive intervals}
\usage{
predictive_interval(object, ...)

\method{predictive_interval}{default}(object, prob = 0.9, ...)
}
\arguments{
\item{object}{The object to use.}

\item{...}{Arguments passed to methods. See the methods in the \pkg{rstanarm}
package for examples.}

\item{prob}{A number \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired
probability mass to include in the intervals.}
}
\value{
\code{predictive_interval} methods should return a matrix with two
  columns and as many rows as data points being predicted. For a given value
  of \code{prob}, \eqn{p}, the columns correspond to the lower and upper
  \eqn{100p}\% interval limits and have the names \eqn{100\alpha/2}\% and
  \eqn{100(1 - \alpha/2)}\%, where \eqn{\alpha = 1-p}. For example, if
  \code{prob=0.9} is specified (a \eqn{90}\% interval), then the column names
  would be \code{"5\%"} and \code{"95\%"}, respectively.

  The default method just takes \code{object} to be a matrix and computes
  quantiles, with \code{prob} defaulting to 0.9.
}
\description{
See \code{\link[rstanarm]{predictive_interval.stanreg}} in the
\pkg{\link[rstanarm]{rstanarm}} package for an example.
}
\examples{
# Default method takes a numeric matrix (of draws from posterior
# predictive distribution)
ytilde <- matrix(rnorm(100 * 5, sd = 2), 100, 5) # fake draws
predictive_interval(ytilde, prob = 0.8)

# Also see help("predictive_interval", package = "rstanarm")

}
\seealso{
\itemize{
  \item The \pkg{\link[rstanarm]{rstanarm}} package for example methods
  (\href{https://CRAN.R-project.org/package=rstanarm}{CRAN},
  \href{https://github.com/stan-dev/rstanarm}{GitHub}).
}

\itemize{
  \item The guidelines for developers of \R packages interfacing with Stan, a
  copy of which can be found in the package vignettes. See
  \code{browseVignettes("rstantools")} or \code{vignette(package =
  "rstantools")}. The document is also available online at the
  \pkg{rstantools} page on the
  \href{https://CRAN.R-project.org/package=rstantools/vignettes/developer-guidelines.html}{CRAN
  website}.
}
}
