% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstantools-package.r
\docType{package}
\name{rstantools-package}
\alias{rstantools-package}
\alias{rstantools}
\title{Tools for Developing \R Packages Interfacing with Stan}
\description{
\if{html}{
  \figure{stanlogo.png}{options: width="50px" alt="mc-stan.org"}
  \emph{Stan Development Team}
}

The \pkg{rstantools} package provides various tools for developers of \R
packages interfacing with Stan (\url{http://mc-stan.org}), including
functions to set up the required package structure, S3 generic methods to
unify function naming across Stan-based \R packages, and a vignette with
guidelines for developers. To get started building a package see
\code{\link{rstan_package_skeleton}}.
}
\seealso{
\itemize{
  \item Guidelines and recommendations for developers of \R packages
  interfacing with Stan and a demonstration getting a simple package working
  can be found in the vignettes included with \pkg{rstantools} and at
  \url{http://mc-stan.org/rstantools/articles/}.
}

\itemize{
  \item After reading the guidelines for developers, if you have trouble
  setting up your package let us know on the the
  \href{http://discourse.mc-stan.org}{Stan Forums} or at
  \href{https://github.com/stan-dev/rstantools/issues}{\pkg{rstantools} issue
  tracker}.
}

\itemize{
  \item The useR2016 presentation
  \href{https://channel9.msdn.com/Events/useR-international-R-User-conferences/useR-International-R-User-2017-Conference/How-to-Use-RStan-to-Estimate-Models-in-External-R-Packages}{How
  to Use (R)Stan to Estimate Models in External R Packages.}
}
}
