% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_test_label.R
\name{get_pwc_label}
\alias{get_pwc_label}
\alias{get_test_label}
\alias{create_test_label}
\title{Extract Label Information from Statistical Tests}
\usage{
get_pwc_label(stat.test, type = c("expression", "text"))

get_test_label(stat.test, description = NULL, p.col = "p",
  type = c("expression", "text"), correction = c("auto", "GG", "HF",
  "none"), row = NULL, detailed = FALSE)

create_test_label(statistic.text, statistic, p, parameter = NA,
  description = NULL, n = NA, effect.size = NA,
  effect.size.text = NA, type = c("expression", "text"),
  detailed = FALSE)
}
\arguments{
\item{stat.test}{statistical test results returned by \code{rstatix}
functions.}

\item{type}{the label type. Can be one of "text" and "expression". Partial
match allowed. If you want to add the label onto a ggplot, it might be
useful to specify \code{type = "expresion"}.}

\item{description}{the test description used as the prefix of the label.
Examples of description are "ANOVA", "Two Way ANOVA". To remove the default
description, specify \code{description = NULL}. If missing, we'll try to
guess the statistical test default description.}

\item{p.col}{character specifying the column containing the p-value. Default
is \code{"p"}, can be \code{"p.adj"}.}

\item{correction}{character, considered only in the case of ANOVA test. Which sphericity
correction of the degrees of freedom should be reported for the
within-subject factors (repeated measures). The default is set to
\code{"GG"} corresponding to the Greenhouse-Geisser correction. Possible
values are \code{"GG"}, \code{"HF"} (i.e., Hyunh-Feldt correction),
\code{"none"} (i.e., no correction) and \code{"auto"} (apply automatically
GG correction if the sphericity assumption is not for within-subject
design.}

\item{row}{numeric, the row index to be considered. If NULL, the last row is
automatically considered for ANOVA test.}

\item{detailed}{logical value. If TRUE, returns detailed label.}

\item{statistic.text}{character specifying the test statistic. For example
\code{statistic.text = "F"} (for ANOVA test ); \code{statistic.text = "t"}
(for t-test ).}

\item{statistic}{the numeric value of a statistic.}

\item{p}{the p-value of the test.}

\item{parameter}{string containing the degree of freedom (if exists). Default
is \code{NA} to accommodate non-parametric tests. For example
\code{parameter = "1,9"} (for ANOVA test. Two parameters exist: DFn and
DFd); \code{sparameter = "9"} (for t-test ).}

\item{n}{sample count, example: \code{n = 10}.}

\item{effect.size}{the effect size value}

\item{effect.size.text}{a character specifying the relevant effect size. For
example, for \code{Cohens d} statistic, \code{effect.size.text = "d"}. You
can also use plotmath expression as follow \code{quote(italic("d"))}.}
}
\value{
a text label or an expression to pass to a plotting function.
}
\description{
Extracts label information from statistical tests. Useful for
  labelling plots with test outputs.
}
\section{Functions}{
\itemize{
\item \code{get_pwc_label}: Extract label from pairwise comparisons.

\item \code{get_test_label}: Extract labels for statistical tests.

\item \code{create_test_label}: Create labels from user specified test results.
}}

\examples{
# Load data
#:::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth

# One-way ANOVA test
#:::::::::::::::::::::::::::::::::::::::::
anov <- df \%>\% anova_test(len ~ dose)
get_test_label(anov, detailed = TRUE, type = "text")

# Two-way ANOVA test
#:::::::::::::::::::::::::::::::::::::::::
anov <- df \%>\% anova_test(len ~ supp*dose)
get_test_label(anov, detailed = TRUE, type = "text",
   description = "Two Way ANOVA")


# Kruskal-Wallis test
#:::::::::::::::::::::::::::::::::::::::::
kruskal<- df \%>\% kruskal_test(len ~ dose)
get_test_label(kruskal, detailed = TRUE, type = "text")

# Wilcoxon test
#:::::::::::::::::::::::::::::::::::::::::
# Unpaired test
wilcox <- df \%>\% wilcox_test(len ~ supp)
get_test_label(wilcox, detailed = TRUE, type = "text")
# Paired test
wilcox <- df \%>\% wilcox_test(len ~ supp, paired = TRUE)
get_test_label(wilcox, detailed = TRUE, type = "text")

# T test
#:::::::::::::::::::::::::::::::::::::::::
ttest <- df \%>\% t_test(len ~ dose)
get_test_label(ttest, detailed = TRUE, type = "text")


# Pairwise comparisons labels
#:::::::::::::::::::::::::::::::::::::::::
get_pwc_label(ttest, type = "text")


# Create test labels
#:::::::::::::::::::::::::::::::::::::::::
create_test_label(
  statistic.text = "F", statistic = 71.82,
  parameter = "4, 294",
  p = "<0.0001",
  description = "ANOVA",
  type = "text"
)

}
