% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_items_parameters.R
\name{generate_intercepts}
\alias{generate_intercepts}
\title{Generating parameters of items - intercepts (thresholds/difficulties)}
\usage{
generate_intercepts(
  nItems,
  scoringMatrix,
  FUNd,
  argsd = NULL,
  FUNt = NULL,
  argst = NULL
)
}
\arguments{
\item{nItems}{number of items for which intercepts will be generated}

\item{scoringMatrix}{\emph{scoring matrix} that will be used for the
generated items, specifically generated with
\code{\link{make_scoring_matrix_aem}} or
\code{\link{make_scoring_matrix_trivial}}}

\item{FUNd}{function that will be used to generate item difficulties,h
typically \code{\link[stats]{Uniform}}, \code{\link[stats]{Normal}} or
\code{\link[truncnorm]{rtruncnorm}}}

\item{argsd}{list of arguments to be passed to \code{FUNd}}

\item{FUNt}{optionally function that will be used to generate item
thresholds (i.e. difficulties of categories relative to difficulty of the
whole item), assuming \emph{simultaneous} item responding process;
typically \code{\link[stats]{Uniform}}, \code{\link[stats]{Normal}} or
\code{\link[truncnorm]{rtruncnorm}}; if not set item responding process is
assumed to be a \emph{sequential} one;}

\item{argst}{optionally list of arguments to be passed to \code{FUNt}}
}
\value{
Matrix of \code{nItems} rows and number of columns equal to the
number of intercepts.
}
\description{
Function generates a matrix of items' intercept
(thresholds/difficulties) parameters.
}
\details{
\strong{Assuming \emph{sequential} response process:}

Assuming \emph{sequential} response process test item must be characterized
by a set of intercept parameters describing individual thresholds of binary
\emph{pseudo-items} modeling consecutive decisions in the assumed sequence
of responding process. In such a case:
\itemize{
  \item{argument \code{FUNd} provides a function that will be used to
        generate thresholds for each of the \code{pseudo-items};}
  \item{argument \code{argsd} provides arguments that will be passed to the
        function provided by \code{FUNd}; elements of this list should rather
        be named; each element of the list should be a vector (typically
        a numeric one) with only one element or as many elements, as the
        number of columns in the \code{scoringMatrix} - in this latter case
        consecutive elements of (each) vector will be passed to separate
        calls of the \code{FUNd} generating thresholds for respective
        \emph{pseudo-items} across all the items;}
  \item{arguments \code{FUNt} and \code{argst} are not used.}
}

Be aware that in this case values in rows of the returned matrix need not be
ordered (as they describe different \emph{pseudo-items}).

\strong{Assuming \emph{simultaneous} response process:}

Assuming \emph{simultaneous} response process test item must be characterized
by a set of intercept parameters describing \emph{difficulty} of transition
between consecutive categories of the response scale. It is convenient to
define such intercepts generating process as a two-step procedure:
1) generate general \emph{difficulties} of the whole items and only then
2) for each item generate values of thresholds relatively to the item
\code{difficulty}, imposing identifiability assumption that these values must
sum up to 0. Consequently in such a case:
\itemize{
  \item{argument \code{FUNd} provides a function that will be used to
        generate general \code{difficulties} of items;}
  \item{argument \code{argsd} provides arguments that will be passed to the
        function provided by \code{FUNd}; elements of this list should rather
        be named; each element of the list should be a vector of length of
        one;}
  \item{argument \code{FUNt} provides a function that will be used to
        generate values of thresholds - generated values will be then sorted
        (descending - due to the parameterization that is used within
        \code{\link{generate_test_responses}}) and centered - consequently it
        is assumed that they are interpreted relatively to the general item
        \emph{difficulty};}
  \item{argument \code{argst} provides arguments that should be passed to the
        function provided by \code{FUNt}; elements of this list should rather
        be named; each element of the list should be a vector of length of
        one or of the length of \code{nItems}; in this latter case
        consecutive elements of (each) vector will be passed to separate
        calls of the \code{FUNt} generating thresholds for consecutive items;}
}

Returned \emph{intercepts} are sums of the general items' \emph{difficulty}
and values of the relative thresholds generated for these items.
}
\examples{
# 5 items with 5-point response scale assuming "sequential" item response
# process with "pseudo-items" intercepts sampled from a uniform distribution
# with limits +-1.5
sM <- make_scoring_matrix_aem(5, sequence = "mae")
generate_intercepts(5, sM, runif, list(min = -1.5, max = 1.5))
# 10 items with 5-point response scale assuming "sequential" item response
# process with "pseudo-items" intercepts sampled from a normal distribution
# with the mean of 0 and the standard deviation of 1.5
sM <- make_scoring_matrix_aem(5, sequence = "mae")
generate_intercepts(5, sM, rnorm, list(mean = 0, sd = 1))
# 10 items with 5-point response scale assuming "sequential" item response
# process with "pseudo-items" intercepts sampled from a uniform distribution
# with limits set to:
# trait 'm' (i.e. the first column in the scoring matrix): from -3 to -1
# trait 'a' (i.e. the second column in the scoring matrix): from -1 to 1
# trait 'e' (i.e. the third column in the scoring matrix): from 1 to 3
sM <- make_scoring_matrix_aem(5, sequence = "mae")
generate_intercepts(10, sM, runif,
                    list(min = c(-3, -1, 1),
                         max = c(-1, 1, 3)))

sM <- make_scoring_matrix_aem(6, sequence = "simultaneous")
# 10 items with 6-point response scale assuming "simultaneous" item response
# process with items difficulties sampled from a normal distribution with
# the mean of 0 and the standard deviation of 1.5 and thresholds relative
# to the items difficulties sampled from a uniform distribution with
# the limits of +-2
sM <- make_scoring_matrix_aem(6, sequence = "simultaneous")
generate_intercepts(10, sM,
                    FUNd = rnorm, argsd = list(mean = 0, sd = 1.5),
                    FUNt = runif, argst = list(min = -2, max = 2))
# 5 items with 6-point response scale assuming "simultaneous" item response
# process with items difficulties sampled from a uniform distribution with
# the limits of +-2 and thresholds relative to the items difficulties sampled
# from a normal distribution with the mean of 0 and the standard deviation
# defined individually for each item
# the limits of +-2
sM <- make_scoring_matrix_aem(6, sequence = "simultaneous")
generate_intercepts(5, sM,
                    FUNd = runif, argsd = list(min = -2, max = 2),
                    FUNt = rnorm, argst = list(mean = 0,
                                               sd = c(1, 1.2, 1.4, 1.6, 1.9)))
# 20 items with 5-point response scale assuming "simultaneous" item response
# process with items difficulties sampled from a uniform distribution with
# the limits of +-2 and thresholds relative to the items difficulties
# generated deterministically as a sequence of 4 regularly spaced values
# from 0.9 to -0.9
sM <- make_scoring_matrix_aem(5, sequence = "simultaneous")
generate_intercepts(20, sM,
                    FUNd = runif, argsd = list(min = -2, max = 2),
                    FUNt = seq, argst = list(from = 0.9,
                                             to = -0.9,
                                             length.out = 4))
}
\seealso{
\code{\link{generate_slopes}}, \code{\link{make_test}}
}
