/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.examples;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.data.discretization.EqualWidthDiscretizer;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGFilters;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.quality.functions.StandardQF;
import org.vikamine.kernel.subgroup.search.BSD;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.subgroup.search.NumericBSD;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGenerator;
import org.vikamine.kernel.subgroup.selectors.SelectorGeneratorUtils;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.subgroup.target.SelectorTarget;
import org.vikamine.kernel.util.VKMUtil;

public class ComplexTaskRunnerExample {
    private final boolean includeNumericAttributes = true;
    private final boolean includeNominalAttributes = true;

    public boolean isIncludeNumericAttributes() {
        return true;
    }

    public boolean isIncludeNominalAttributes() {
        return true;
    }

    private ComplexTaskRunnerExample() {
    }

    public static void main(String[] args) throws IOException {
        SGTarget target;
        Ontology onto = DataFactory.createOntology(new File("../org.vikamine.kernel.test/resources/datasets/credit-g.arff"));
        ComplexTaskRunnerExample miner = new ComplexTaskRunnerExample();
        Attribute targetAttribute = onto.getAttribute("class");
        if (targetAttribute.isNominal()) {
            NominalAttribute nominalTargetAttribute = (NominalAttribute)targetAttribute;
            DefaultSGSelector targetSelector = new DefaultSGSelector((Attribute)nominalTargetAttribute, nominalTargetAttribute.getNominalValue(0));
            target = new SelectorTarget(targetSelector);
        } else if (targetAttribute.isNumeric()) {
            NumericAttribute numericTargetAttribute = (NumericAttribute)targetAttribute;
            target = new NumericTarget(numericTargetAttribute);
        } else {
            throw new IllegalStateException("Unknown type of target attribute");
        }
        List<SG> subgroups = miner.discoverSubgroups(target, onto);
        if (target.isBoolean()) {
            miner.printSubgroupsForBooleanTarget(subgroups);
        } else if (target.isNumeric()) {
            miner.printSubgroupsForNumericTarget(subgroups);
        }
    }

    public List<SG> discoverSubgroups(SGTarget target, Ontology onto) {
        LinkedHashSet<Attribute> attributes = onto.getAttributes();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            Attribute next = (Attribute)iter.next();
            if (target.getAttributes().contains(next)) {
                iter.remove();
            }
            if (!this.isIncludeNominalAttributes() && next.isNominal()) {
                iter.remove();
            }
            if (this.isIncludeNumericAttributes() || !next.isNumeric()) continue;
            iter.remove();
        }
        SGSelectorGenerator.SplitSelectorGenerator generator = new SGSelectorGenerator.SplitSelectorGenerator(new SGSelectorGenerator.SimpleValueSelectorGenerator(), new SGSelectorGenerator.SimpleNumericSelectorGenerator(new EqualWidthDiscretizer(3)));
        List<SGSelector> allSelectors = SelectorGeneratorUtils.generateSelectors(generator, attributes, onto.getDataView());
        System.out.println("Number of selectors (total): " + allSelectors.size());
        MiningTask task = new MiningTask();
        task.setOntology(onto);
        ArrayList<SGSelector> relevantSelectors = new ArrayList<SGSelector>(allSelectors);
        task.setSearchSpace(relevantSelectors);
        task.setTarget(target);
        SG initialSG = new SG(onto.getDataView(), task.getTarget());
        initialSG.createStatistics(null);
        task.setInitialSG(initialSG);
        task.setQualityFunction(new StandardQF(0.5));
        if (target.isNumeric()) {
            task.setMethodType(NumericBSD.class);
        } else {
            task.setMethodType(BSD.class);
        }
        task.setMaxSGDSize(3);
        task.setMinSubgroupSize(20.0);
        task.setMaxSGCount(20);
        System.out.println("Starting subgroup discovery for target: " + target.getDescription());
        SGSet result = task.performSubgroupDiscovery();
        result = new SGFilters.MinImprovementFilterGlobal(0.001).filterSGs(result);
        List<SG> resultList = result.toSortedList(false);
        return resultList;
    }

    public void printSubgroupsForBooleanTarget(List<SG> subgroups) {
        System.out.println("Printing result set\n");
        System.out.println("=======");
        System.out.println("Target\tSize\tConfidence\tDescription");
        for (SG sg : subgroups) {
            SGStatisticsBinary stats = (SGStatisticsBinary)sg.getStatistics();
            System.out.print(String.valueOf(sg.getTarget().getDescription()) + "\t");
            System.out.print(String.valueOf(VKMUtil.getFormattedDoubleString(stats.getSubgroupSize(), 0)) + "\t" + VKMUtil.getFormattedDoubleString(stats.getP(), 2));
            for (SGSelector sel : sg.getDescription().getSelectors()) {
                System.out.print("\t" + sel.getDescription());
            }
            System.out.println("");
        }
        System.out.println("=======");
    }

    public void printSubgroupsForNumericTarget(List<SG> subgroups) {
        System.out.println("Printing result set\n");
        System.out.println("=======");
        System.out.println("Target\tSize\tDeviation\tDescription");
        for (SG sg : subgroups) {
            SGStatisticsNumeric stats = (SGStatisticsNumeric)sg.getStatistics();
            System.out.print(String.valueOf(sg.getTarget().getDescription()) + "\t");
            System.out.print(String.valueOf(VKMUtil.getFormattedDoubleString(stats.getSubgroupSize(), 0)) + "\t" + VKMUtil.getFormattedDoubleString(stats.getDeviation(), 2));
            for (SGSelector sel : sg.getDescription().getSelectors()) {
                System.out.print("\t" + sel.getDescription());
            }
            System.out.println("");
        }
        System.out.println("=======");
    }
}

