/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula.constants;

import java.util.Collections;
import java.util.Set;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.formula.EvaluationData;
import org.vikamine.kernel.formula.FormulaNumberElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FormulaAttributePrimitive
implements FormulaNumberElement {
    private Attribute attribute;
    private String name = "";

    @Override
    public synchronized Double eval(EvaluationData data) {
        return new Double(data.getInstance().getValue(this.attribute));
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public FormulaAttributePrimitive(Attribute attribute) {
        this.attribute = attribute;
        this.name = attribute.getDescription();
    }

    public FormulaAttributePrimitive() {
    }

    @Override
    public Set getAttributes() {
        return Collections.singleton(this.getAttribute());
    }

    @Override
    public Element createDOMNode(Document doc) {
        Element elem = doc.createElement("formula");
        elem.setAttribute("symbol", "attribute");
        elem.setAttribute("attribute", this.getAttribute().getId());
        return elem;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    @Override
    public boolean isEqual(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.attribute.equals(((FormulaAttributePrimitive)other).attribute);
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    @Override
    public int computeHashCode() {
        return this.attribute.hashCode();
    }
}

